﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// ------------------------------------------------------------------------------------------------
// WorkerUtil
// ------------------------------------------------------------------------------------------------
class WorkerUtil
{
public:
    typedef nn::Result (*Func)(void* ptr);
    typedef void (*DoneCallbackFunc)();

    enum Error
    {
        Error_Ok = 0,
        Error_Fatal,
        Error_Inprogress,
        Error_NotRunning,
    };

    WorkerUtil(
        Func pFunc,
        DoneCallbackFunc pDoneCallbackFunc,
        void* pUserPtr,
        int threadStaskSize);
    ~WorkerUtil();
    Error AddTask();
    Error Run(int threadPriority);
    Error WaitToBeDone();
    nn::Result GetResult();

private:
    enum State
    {
        State_Invalid = 0,
        State_Initialized,
        State_Running,
        State_Done,
    };

    nn::os::Event      m_WaitToBeDone;
    nn::Result         m_Result;
    int                m_ThreadStackSize;
    char*              m_pThreadStack;
    nn::os::ThreadType m_ThreadTid;
    Func               m_pFunc;
    DoneCallbackFunc   m_pDoneCallbackFunc;
    void*              m_pUserPtr;
    State              m_State;

    static void ExecuteWorker(void* pWorker);
};

