﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "ExecuterTestsBase.h"

// ------------------------------------------------------------------------------------------------
// ExecuterTestCaseRunContextConnection
// ------------------------------------------------------------------------------------------------
class ExecuterTestsRunContextConnection : public ExecuterTestsBase
{
    uint32_t m_RunCount;
    char     m_HostName[128];
    uint16_t m_Port;

public:
    NN_IMPLICIT ExecuterTestsRunContextConnection(uint32_t count);
    ExecuterTestsRunContextConnection(
        const char* pInHostName,
        uint16_t port,
        uint32_t count);
    ~ExecuterTestsRunContextConnection();
    void Run();
};

