﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <cstdio>
#include <cstring>
#include <cstdlib>

#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/init.h>
#include <nn/os.h>

#include <nn/ssl.h>
#include <nn/ssl/ssl_Api.debug.h>
#include <nn/socket.h>

#include "ExecuterTestsBase.h"
#include "ExecuterTestsRunClientPkiImport.h"
#include "PkiResources.h"

// ------------------------------------------------------------------------------------------------
// ExecuterTestsRunClientPkiImport
// ------------------------------------------------------------------------------------------------
ExecuterTestsRunClientPkiImport::ExecuterTestsRunClientPkiImport(uint32_t count)
{
    m_RunCount = (count > 0)?count:1;
}

ExecuterTestsRunClientPkiImport::~ExecuterTestsRunClientPkiImport()
{
}

void ExecuterTestsRunClientPkiImport::Run()
{
    nn::Result result;

    nn::ssl::Debug::HeapTrackPoint tracker;
    StartHeapTrack(&tracker);

    for (uint32_t i = 0; i < m_RunCount; i++)
    {
        nn::ssl::Context* pSslContext;

        do
        {
            pSslContext = new nn::ssl::Context();
            if (pSslContext == nullptr)
            {
                NN_LOG(" Faild to allocate a memory for a context.\n");
            }

            result = pSslContext->Create(nn::ssl::Context::SslVersion_Auto);
            if (result.IsFailure())
            {
                break;
            }

            nn::ssl::CertStoreId clientCertStoreId;
            result = pSslContext->ImportClientPki(
                &clientCertStoreId,
                reinterpret_cast<const char*>(PkiResources::ClientPki1::Data),
                reinterpret_cast<const char*>(PkiResources::ClientPki1::Password),
                PkiResources::ClientPki1::DataSize,
                PkiResources::ClientPki1::PasswordLength);
            if (result.IsFailure())
            {
                NN_LOG(" Faild to import a client PKI.\n");
                break;
            }
        } while (NN_STATIC_CONDITION(false));

        if (pSslContext != nullptr)
        {
            nn::ssl::SslContextId ctxId;
            pSslContext->GetContextId(&ctxId);
            if (ctxId != 0)
            {
                result = pSslContext->Destroy();
                if (result.IsFailure())
                {
                    TEST_CASE_VERBOSE_LOG(" Failed to destroy a SSL context.\n");
                }
            }

            delete pSslContext;
        }

        NN_LOG(" count: %d\n", i + 1);
        ExecuterTestsBase::SetResult(result.IsSuccess());
    }

    EndHeapTrack(&tracker);
    ExecuterTestsBase::PrintResult();
}

