﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "ExecuterTestsBase.h"

// ------------------------------------------------------------------------------------------------
// ExecuterTestsRunAbuse
// ------------------------------------------------------------------------------------------------
class ExecuterTestsRunAbuse : public ExecuterTestsBase
{
public:
    static const int  ThreadMaxCount         = 8;
    static const int  DefaultThreadStackSize = 1024 * 64;
    static const int  ReadBufferSize         = 1024 * 512;
    static const int  NormalHttpsPort        = 443;
    static const int  HostNameLength         = 256;
    static const int  PolicyOidStringLength  = 256;

    static const char TestHosts[][HostNameLength];
    static const char TestHostsEv[][HostNameLength];
    static const char UserOidList[][HostNameLength];
    static const char TestHostNintendo[];

    typedef struct Config
    {
        uint32_t                              connectionCount;
        nn::ssl::Connection::IoMode           ioMode;
        nn::ssl::Connection::SessionCacheMode sessionCacheMode;
        nn::ssl::Connection::VerifyOption     verifyOption;
        bool                                  isImportServerPki;
        bool                                  isImportClientPki;
        bool                                  isImportInternalPki;
        bool                                  isClearSessionCache;
        bool                                  isGetServerCert;
    } Config;

    NN_IMPLICIT ExecuterTestsRunAbuse(uint32_t count);
    ~ExecuterTestsRunAbuse();
    void Run();
    void SetConfig(Config* pInConfig);
    Config* GetConfig();

    static const char* GetCurrentHost();
    static uint32_t    GetPolicyOidCount();
    static const char* GetPolicyOidString(uint32_t index);
    static uint32_t    GetEvHostCount();
    static const char* GetEvHost(uint32_t index);

private:
    static nn::os::Mutex g_Mutex;
    static uint32_t      g_TestHostIndex;

    uint32_t m_RunCount;
    Config   m_Config;
};

