﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ssl.h>
#include <nn/ssl/ssl_Api.debug.h>

#define TEST_CASE_VERBOSE_LOG(...)                                                                \
    do {                                                                                          \
        if (IsVerbose() == true)                                                                  \
            NN_LOG(__VA_ARGS__);                                                                  \
    } while (NN_STATIC_CONDITION(false))

class ExecuterTestsBase
{
    bool m_IsSucceeded;
    bool m_IsVerbose;

public:
    ExecuterTestsBase();
    virtual void Run() = 0;
    bool IsSucceeded();
    void EnableVerbose();
    bool IsVerbose();
    void PrintResult();
    void SetResult(bool isSuccessed);

    int CreateTcpSocket(
        bool bEstablishConn,
        uint16_t portNumber,
        const char* pInHostName,
        uint32_t ipAddress);

    nn::Result PerformHandshake(
        const char* pInHostName,
        nn::ssl::Context    *pSslContext,
        nn::ssl::Connection *pSslConnection,
        uint16_t portNumber,
        nn::ssl::Connection::VerifyOption verifyOption,
        nn::ssl::Connection::SessionCacheMode sessionCacheMode,
        nn::ssl::Connection::IoMode ioMode,
        bool contextsReady,
        bool keepConnection,
        bool returnUponHandshakeFailure,
        bool getServerCert);

    void StartHeapTrack(nn::ssl::Debug::HeapTrackPoint* pInTracker);
    void EndHeapTrack(nn::ssl::Debug::HeapTrackPoint* pInTracker);
};
