﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nnt/gtest/gtest.h>
#include <nn/nn_Assert.h>

inline void DebugResult(nn::Result result)
{
    NN_LOG("[Result] Module=%d, Description=%d\n", result.GetModule(), result.GetDescription());
}

#define ASSERT_RESULT_SUCCESS(result) \
    do { \
        if (result.IsFailure()) \
        { \
            NN_LOG("Assert at '%s':%d\n", __FILE__, __LINE__); \
            DebugResult(result); \
        } \
        ASSERT_TRUE(result.IsSuccess()); \
    } while(false)

#define ASSERT_RESULT_FAILURE_VALUE(result, expect) \
    do { \
        if (!(result <= expect)) \
        { \
            NN_LOG("Assert at '%s':%d\n", __FILE__, __LINE__); \
            DebugResult(result); \
        } \
        ASSERT_TRUE(result <= expect); \
    } while(false)

#define NN_ASSERT_RESULT_SUCCESS(result) \
    do { \
        if (result.IsFailure()) \
        { \
            NN_LOG("Assert at '%s':%d\n", __FILE__, __LINE__); \
            DebugResult(result); \
        } \
        NN_ASSERT(result.IsSuccess()); \
    } while(false)

#define NN_ASSERT_RESULT_FAILURE_VALUE(result, expect) \
    do { \
        if (!(result <= expect)) \
        { \
            NN_LOG("Assert at '%s':%d\n", __FILE__, __LINE__); \
            DebugResult(result); \
        } \
        NN_ASSERT(result <= expect); \
    } while(false)

