﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Assert.h>
#include <nn/os.h>
#include <nn/mem/mem_StandardAllocator.h>
#include "util_TestAllocator.h"
#include "test_HeapConfig.h"
#include "util_TestResult.h"

TestAllocator::TestAllocator() NN_NOEXCEPT
{
    auto result = nn::os::AllocateMemoryBlock(&m_HeapAddress, HeapMemorySize);
    NN_ASSERT_RESULT_SUCCESS(result);

    m_Allocator.Initialize(reinterpret_cast<void*>(m_HeapAddress), HeapMemorySize);
}

TestAllocator::~TestAllocator() NN_NOEXCEPT
{
    m_Allocator.Finalize();
    nn::os::FreeMemoryBlock(m_HeapAddress, HeapMemorySize);
}

