﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ro.h>
#include <nn/ro/ro_Types.h>

#include "util_Common.h"

#include <nn/nn_Log.h>

namespace {
    const char* BinLocalName = "nro/BinLocal.nro";

    typedef int (*ReturnInt)();
    typedef void (*SetInt)(int);
    const char* GetLocalValueFuncName = "_Z13GetLocalValuev";
    const char* SetLocalValueFuncName = "_Z13SetLocalValuei";
    const char* GetLocalValueFromGlobalFuncName = "_Z23GetLocalValueFromGlobalv";
    const char* SetLocalValueFromGlobalFuncName = "_Z23SetLocalValueFromGlobali";
    const char* LocalValueName = "g_LocalValue";

    class LocalTest : public ::testing::TestWithParam<nn::ro::BindFlag>
    {
    protected:
        virtual void SetUp()
        {
            m_Allocator = &TestAllocator::GetInstance();
            m_Nro.SetUp(BinLocalName, m_Allocator->GetAllocator());
            nn::ro::Initialize();
        }

        virtual void TearDown()
        {
            nn::ro::Finalize();
        }

        TestAllocator* m_Allocator;
        TestNro m_Nro;
    };

} // namespace

INSTANTIATE_TEST_CASE_P(ManualDll, LocalTest, ::testing::Values(nn::ro::BindFlag_Lazy, nn::ro::BindFlag_Now));

// Local 変数や関数にアクセスできない。
// Local 内ではアクセスできる。
TEST_P(LocalTest, Bind)
{
    auto result = m_Nro.Load(GetParam());
    ASSERT_RESULT_SUCCESS(result);

    uintptr_t addr;

    result = nn::ro::LookupSymbol(&addr, GetLocalValueFuncName);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::ro::ResultNotFound());

    result = nn::ro::LookupSymbol(&addr, SetLocalValueFuncName);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::ro::ResultNotFound());

    result = nn::ro::LookupSymbol(&addr, LocalValueName);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::ro::ResultNotFound());

    result = nn::ro::LookupSymbol(&addr, SetLocalValueFromGlobalFuncName);
    ASSERT_RESULT_SUCCESS(result);

    SetInt setter = reinterpret_cast<SetInt>(addr);
    setter(10);

    result = nn::ro::LookupSymbol(&addr, GetLocalValueFromGlobalFuncName);
    ASSERT_RESULT_SUCCESS(result);

    ReturnInt getter = reinterpret_cast<ReturnInt>(addr);
    ASSERT_EQ(getter(), 10);

    setter(20);
    ASSERT_EQ(getter(), 20);

    m_Nro.Unload();
}

