﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ro.h>
#include <nn/ro/ro_Types.h>

#include "util_Common.h"

#include <nn/nn_Log.h>

namespace {
    const char* BinLoadDllName = "nro/BinLoadDll.nro";

    typedef void (*ReturnVoid)();
    typedef void (*LoadOtherDll)(nn::ro::BindFlag flag);
    typedef int (*ReturnInt)();

    const char* LoadOtherDllName = "_Z16TestLoadOtherDllN2nn2ro8BindFlagE";
    const char* UnloadOtherDllName = "_Z14UnloadOtherDllv";
    const char* ExternalFunctionName = "_Z16ExternalFunctionv";
    const char* ExternalValueName = "g_ExternValue";

    class LoadFromDllTest : public ::testing::TestWithParam<nn::ro::BindFlag>
    {
    protected:

        virtual void SetUp()
        {
            m_Allocator = &TestAllocator::GetInstance();
            m_Nro.SetUp(BinLoadDllName, m_Allocator->GetAllocator());
            nn::ro::Initialize();
        }

        virtual void TearDown()
        {
            nn::ro::Finalize();
        }

        TestAllocator* m_Allocator;
        TestNro m_Nro;
    };

} // namespace

INSTANTIATE_TEST_CASE_P(ManualDll, LoadFromDllTest, ::testing::Values(nn::ro::BindFlag_Lazy, nn::ro::BindFlag_Now));

TEST_P(LoadFromDllTest, Bind)
{
    auto result = m_Nro.Load(GetParam());
    ASSERT_RESULT_SUCCESS(result);

    uintptr_t addr;

    result = nn::ro::LookupSymbol(&addr, LoadOtherDllName);
    ASSERT_RESULT_SUCCESS(result);
    LoadOtherDll load = reinterpret_cast<LoadOtherDll>(addr);
    load(GetParam());

    result = nn::ro::LookupSymbol(&addr, ExternalFunctionName);
    ASSERT_RESULT_SUCCESS(result);

    ReturnInt getInt = reinterpret_cast<ReturnInt>(addr);
    ASSERT_EQ(getInt(), 10);

    result = nn::ro::LookupSymbol(&addr, ExternalValueName);
    ASSERT_RESULT_SUCCESS(result);
    int* ptr = reinterpret_cast<int*>(addr);
    ASSERT_EQ(*ptr, 10);

    result = nn::ro::LookupSymbol(&addr, UnloadOtherDllName);
    ASSERT_RESULT_SUCCESS(result);
    ReturnVoid unload = reinterpret_cast<ReturnVoid>(addr);
    unload();

    result = nn::ro::LookupSymbol(&addr, ExternalFunctionName);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::ro::ResultNotFound());

    m_Nro.Unload();
}

