﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ro.h>
#include <nn/ro/ro_Types.h>

#include "util_Common.h"

#include <nn/nn_Log.h>


namespace {
    const char* BinExceptionName = "nro/BinException.nro";
    typedef void (*CallFunc)();
    const char* ExceptionFuncName = "_Z13ExceptionTestv";

    class ExceptionTest : public ::testing::TestWithParam<nn::ro::BindFlag>
    {
    protected:

        virtual void SetUp()
        {
            m_Allocator = &TestAllocator::GetInstance();
            m_Nro.SetUp(BinExceptionName, m_Allocator->GetAllocator());
            nn::ro::Initialize();
        }

        virtual void TearDown()
        {
            nn::ro::Finalize();
        }

        TestAllocator* m_Allocator;
        TestNro m_Nro;
        TestNro m_Caller;
    };

} // namespace

INSTANTIATE_TEST_CASE_P(ManualDll, ExceptionTest, ::testing::Values(nn::ro::BindFlag_Lazy, nn::ro::BindFlag_Now));

// 例外を利用することが出来る
TEST_P(ExceptionTest, Bind)
{
    auto result = m_Nro.Load(GetParam());
    ASSERT_RESULT_SUCCESS(result);

    uintptr_t addr;

    result = m_Nro.FindSymbol(&addr, ExceptionFuncName);
    ASSERT_RESULT_SUCCESS(result);

    // 自分の DLL 内で例外を補足できる
    try
    {
        throw 1;
    }
    catch (int e)
    {
        ASSERT_EQ(e, 1);
    }

    CallFunc func = reinterpret_cast<CallFunc>(addr);
    ASSERT_TRUE(func != nullptr);

    // ロードした DLL 内で発生した例外を補足できる
    bool check = false;
    try
    {
        func();
    }
    catch (int e)
    {
        ASSERT_EQ(e, 3);
        check = true;
    }
    ASSERT_TRUE(check);

    m_Nro.Unload();
}

