﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Result.h>
#include <nn/nn_Macro.h>
#include <nn/nn_SdkAssert.h>

#include <nn/os.h>
//#include <nn/fs/fs_Host.h>

#include <nn/time/time_ApiForMenu.h>
#include <nn/account/account_Api.h>
#include <nn/bpc/bpc_WakeupConfig.h>
#include <nn/psm/psm_Api.h>

#include <nn/diag/diag_AbortObserverSystemApi.h>
#include <nn/nifm/nifm_Api.h>
#include <nn/ns/ns_InitializationApi.h>
#include <nn/npns/npns_ApiSystem.h>

#include <nnt/nntest.h>
#include <nnt/result/testResult_Assert.h>

#include <nn/rid/rid_Initialize.h>
#include <nn/rid/rid_StartUpApi.h>

#include "RidCompatibilityVerifier_Option.h"

const char HelpMessage[] =
    "\n [Error] Some argument specification is required. \n"
    "  usage : RidCompatibilityVerifier --prepare\n"
    "        : RidCompatibilityVerifier --display\n"
    "        : RidCompatibilityVerifier --system-update\n"
    "        : RidCompatibilityVerifier --menu-update\n"
    "        : RidCompatibilityVerifier --application-update\n"
    "\n";

// 本テストにおける Menu 用アプリケーション ID 定義
const nn::ncm::ApplicationId MenuApplicationId = { 0x01001a500005e011 };

void Initialize() NN_NOEXCEPT
{
    nn::diag::InitializeSystemProcessAbortObserver();

    nn::nifm::Initialize();
    nn::ns::Initialize();
    nn::npns::InitializeForSystem();

    nn::psm::Initialize();  //! 電源ライブラリ
    nn::account::Initialize();

    nn::rid::Initialize(MenuApplicationId);

    auto result = nn::rid::MinimumStartUp();
    NNT_EXPECT_RESULT_SUCCESS(result);
}

void Finalize() NN_NOEXCEPT
{
    // ひとまず特に何もしない
}

int Process(int argc, char** argv) NN_NOEXCEPT
{
    ::testing::InitGoogleTest(&argc, argv);

    if (argc < 2)
    {
        // 何らかの引数指定が必要であることを返す
        NN_LOG(HelpMessage);
        return 1;
    }

    auto result = nn::rid::CheckRetailInteractiveDisplayDevice();
    if (result.IsFailure())
    {
        NN_LOG("\n [Error] Not RetailInteractiveDisplayDevice\n\n");
        return 1;
    }

    Option::SetArgument(argc, argv);

    return RUN_ALL_TESTS();;
}

extern "C" void nnMain()
{
    Initialize();

    // ひとまず返り値判定は実施しない
    Process(nn::os::GetHostArgc(), nn::os::GetHostArgv());

    Finalize();
}

