﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnc/nn_Result.h>
#include <nnc/nn_ErrorResult.h>

#define NN_DEFINE_ERROR_RANGE_RESULT_PREFIX nntfoo

    NN_DEFINE_ABSTRACT_ERROR_RANGE_RESULT(ResultAll, 10, 0, 300)
        NN_DEFINE_ABSTRACT_ERROR_RANGE_RESULT(ResultA, 10, 0, 100)
            NN_DEFINE_ERROR_RANGE_RESULT(ResultA1, 10, 1, 2)
            NN_DEFINE_ERROR_RANGE_RESULT(ResultA2, 10, 2, 3)
        NN_DEFINE_ERROR_RANGE_RESULT(ResultB, 10, 100, 200)
            NN_DEFINE_ERROR_RANGE_RESULT(ResultB1, 10, 101, 102)
        NN_DEFINE_ERROR_RANGE_RESULT(ResultC, 10, 200, 300)
    NN_DEFINE_ERROR_RANGE_RESULT(ResultOther, 20, 0, 500)

    NN_DEFINE_ERROR_RANGE_RESULT(ResultModuleMax, 511, 0, 1)
    NN_DEFINE_ERROR_RANGE_RESULT(ResultDescriptionMax, 1, 8191, 8192)

#undef NN_DEFINE_ERROR_RANGE_RESULT_PREFIX

// 複数の NN_DEFINE_ERROR_RANGE_RESULT_PREFIX を使用できることの確認
#define NN_DEFINE_ERROR_RANGE_RESULT_PREFIX nntbar

    NN_DEFINE_ABSTRACT_ERROR_RANGE_RESULT(ResultAll, 11, 0, 300)

#undef NN_DEFINE_ERROR_RANGE_RESULT_GET_PREFIX

void CCompileCheck(void)  // NOLINT(readability/function)
{
    nnResult resultSuccess = nnResultSuccess();
    nnResult resultA1 = nntfooMakeResultA1();
    bool b = nntfooResultAIncludes(resultA1);
    (void)b;
    int m = nnResultGetModule(resultA1);
    int d = nnResultGetDescription(resultA1);
    (void)m;
    (void)d;
}
