﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/usb/usb_PmTypes.h>

#include "testPsm_UsbPmStub.h"

namespace {
    nn::usb::UsbPowerState  g_PowerState;
    nn::os::SystemEventType g_PowerEvent;
}

namespace nn { namespace usb {

Result PmClient::Initialize() NN_NOEXCEPT
{
    nn::os::CreateSystemEvent(&g_PowerEvent, nn::os::EventClearMode_ManualClear, false);
    NN_RESULT_SUCCESS;
}

Result PmClient::Finalize() NN_NOEXCEPT
{
    nn::os::DestroySystemEvent(&g_PowerEvent);
    NN_RESULT_SUCCESS;
}

nn::os::SystemEventType* PmClient::GetPowerEvent() NN_NOEXCEPT
{
    return &g_PowerEvent;
}

Result PmClient::GetPowerState(UsbPowerState *pOutState) NN_NOEXCEPT
{
    NN_ASSERT_NOT_NULL(pOutState);
    *pOutState = g_PowerState;
    NN_RESULT_SUCCESS;
}

}} // namespace nn::usb

namespace nnt { namespace usb {

void SetPmPowerState(const nn::usb::UsbPowerState& state) NN_NOEXCEPT
{
    g_PowerState = state;
}

void SignalPmPowerEvent() NN_NOEXCEPT
{
    nn::os::SignalSystemEvent(&g_PowerEvent);
}

}} // namespace nnt::usb
