﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/ovln/ovln_SenderForOverlay.h>
#include <nn/result/result_HandlingUtility.h>

namespace {

::nn::ovln::Message g_LastMessage;

} // namespace

namespace nn { namespace ovln {

Result InitializeSenderLibraryForOverlay() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

void FinalizeSenderLibraryForOverlay() NN_NOEXCEPT
{
}

Result InitializeSenderForValue(SenderForOverlayType* pSender) NN_NOEXCEPT
{
    NN_UNUSED(pSender);

    NN_RESULT_SUCCESS;
}

void FinalizeSender(SenderForOverlayType* pSender) NN_NOEXCEPT
{
    NN_UNUSED(pSender);
}

bool Send(SenderForOverlayType* pSender, const Message& message) NN_NOEXCEPT
{
    NN_UNUSED(pSender);

    g_LastMessage = message;

    return true;
}

}} // namespace ::nn::ovln

namespace nnt { namespace ovln {

::nn::ovln::Message GetLastMessage() NN_NOEXCEPT
{
    return g_LastMessage;
}

}} // namespace ::nnt::ovln
