﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/psm/psm.h>
#include <nn/psm/psm_Manufacture.h>

#include <nnt/nntest.h>

#include "testPsm_Common.h"

namespace nnt { namespace psm {

namespace {

struct PsmManufactureSupplyRoutePolicyTestSetting
{
    UsbPowerState usbPowerState;
    Vdd50Condition expectedVdd50Condition;
};

const PsmManufactureSupplyRoutePolicyTestSetting PsmManufactureSupplyRoutePolicyTestSettings[] =
{
    { UsbPowerState::He15V,    Vdd50Condition_Vdd50B },
    { UsbPowerState::Inactive, Vdd50Condition_Vdd50A },
};

class PsmManufactureSupplyRoutePolicyTest : public ::testing::TestWithParam<PsmManufactureSupplyRoutePolicyTestSetting>
{
public:
    static void SetUpTestCase()
    {
        ::nnt::psm::Initialize();
    }

    static void TearDownTestCase()
    {
        ::nnt::psm::Finalize();
    }
};

INSTANTIATE_TEST_CASE_P(PsmManufactureSupplyRoutePolicyTestName, PsmManufactureSupplyRoutePolicyTest, ::testing::ValuesIn(PsmManufactureSupplyRoutePolicyTestSettings));

}

// TODO: Vdd50Condition と言う表現も古いので改めたいです。
TEST_P(PsmManufactureSupplyRoutePolicyTest, CheckSupplyRouteFunctions)
{
    // SupplyRoute の切り替えを確認します
    nn::psm::SetSupplyRoute(nn::psm::SupplyRoute_Vdd50A);
    CheckVdd50Condition(Vdd50Condition_Vdd50A);
    ChangeUsbPowerState(GetParam().usbPowerState);
    CheckVdd50Condition(GetParam().expectedVdd50Condition);

    nn::psm::SetSupplyRoute(nn::psm::SupplyRoute_Vdd50B);
    CheckVdd50Condition(Vdd50Condition_Vdd50B);
    ChangeUsbPowerState(GetParam().usbPowerState);
    CheckVdd50Condition(GetParam().expectedVdd50Condition);

    // SupplyRoute の切り替えを無効化します
    nn::psm::DisableSupplyRouteControl();

    // SupplyRoute の切り替えを確認します
    nn::psm::SetSupplyRoute(nn::psm::SupplyRoute_Vdd50A);
    CheckVdd50Condition(Vdd50Condition_Vdd50A);
    ChangeUsbPowerState(GetParam().usbPowerState);
    CheckVdd50Condition(Vdd50Condition_Vdd50A);

    nn::psm::SetSupplyRoute(nn::psm::SupplyRoute_Vdd50B);
    CheckVdd50Condition(Vdd50Condition_Vdd50B);
    ChangeUsbPowerState(GetParam().usbPowerState);
    nn::psm::SetSupplyRoute(nn::psm::SupplyRoute_Vdd50B);

    // SupplyRoute の切り替えの有効化します
    nn::psm::EnableSupplyRouteControl();

    // SupplyRoute の切り替えを確認します
    nn::psm::SetSupplyRoute(nn::psm::SupplyRoute_Vdd50A);
    CheckVdd50Condition(Vdd50Condition_Vdd50A);
    ChangeUsbPowerState(GetParam().usbPowerState);
    CheckVdd50Condition(GetParam().expectedVdd50Condition);

    nn::psm::SetSupplyRoute(nn::psm::SupplyRoute_Vdd50B);
    CheckVdd50Condition(Vdd50Condition_Vdd50B);
    ChangeUsbPowerState(GetParam().usbPowerState);
    CheckVdd50Condition(GetParam().expectedVdd50Condition);
}

}} // namespace nnt::psm
