﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/psm/driver/detail/psm_Constants.h>
#include <nn/psm/driver/psm.h>
#include <nn/psm/psm.h>

#include <nnt/nntest.h>

#include "testPsm_ChargerDriverStub.h"
#include "testPsm_Common.h"

namespace nnt { namespace psm {

namespace {

struct PsmChargeVoltageLimitPolicyTestSetting
{
    //! 電池温度（電池電圧とセットで一つの因子）
    double batteryTemperatureCelsius;

    //! 電池電圧（電池温度とセットで一つの因子）
    int batteryVoltageMilliVolt;

    //! 充電電圧上限の期待値
    int chargeVoltageLimit;
};

const PsmChargeVoltageLimitPolicyTestSetting PsmChargeVoltageLimitPolicyTestSettings[] =
{
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdTooLow  - 0.1, 4049, ::nn::psm::driver::detail::ChargeVoltageLimitMilliVoltDefault         },
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdLow     - 0.1, 4049, ::nn::psm::driver::detail::ChargeVoltageLimitMilliVoltDefault         },
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdLow,           4049, ::nn::psm::driver::detail::ChargeVoltageLimitMilliVoltDefault         },
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdHigh    - 0.1, 4049, ::nn::psm::driver::detail::ChargeVoltageLimitMilliVoltDefault         },
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdHigh,          4049, ::nn::psm::driver::detail::ChargeVoltageLimitMilliVoltHighTemperature },
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdTooHigh - 0.1, 4049, ::nn::psm::driver::detail::ChargeVoltageLimitMilliVoltHighTemperature },
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdTooHigh,       4049, ::nn::psm::driver::detail::ChargeVoltageLimitMilliVoltHighTemperature },

    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdTooLow  - 0.1, 4050, ::nn::psm::driver::detail::ChargeVoltageLimitMilliVoltDefault         },
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdLow     - 0.1, 4050, ::nn::psm::driver::detail::ChargeVoltageLimitMilliVoltDefault         },
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdLow,           4050, ::nn::psm::driver::detail::ChargeVoltageLimitMilliVoltDefault         },
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdHigh    - 0.1, 4050, ::nn::psm::driver::detail::ChargeVoltageLimitMilliVoltDefault         },
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdHigh,          4050, ::nn::psm::driver::detail::ChargeVoltageLimitMilliVoltDefault         },
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdTooHigh - 0.1, 4050, ::nn::psm::driver::detail::ChargeVoltageLimitMilliVoltDefault         },
    { ::nn::psm::driver::detail::BatteryTemperatureCelsiusThresholdTooHigh,       4050, ::nn::psm::driver::detail::ChargeVoltageLimitMilliVoltDefault         },
};

class PsmChargeVoltageLimitPolicyTest : public ::testing::TestWithParam<PsmChargeVoltageLimitPolicyTestSetting>
{
public:
    static void SetUpTestCase()
    {
        ::nnt::psm::Initialize();
    }

    static void TearDownTestCase()
    {
        ::nnt::psm::Finalize();
    }
};

INSTANTIATE_TEST_CASE_P(PsmChargeVoltageLimitPolicyTestName, PsmChargeVoltageLimitPolicyTest, ::testing::ValuesIn(PsmChargeVoltageLimitPolicyTestSettings));

} // namespace

TEST_P(PsmChargeVoltageLimitPolicyTest, CheckChargeSettings)
{
    ChangeBatteryTemperature(GetParam().batteryTemperatureCelsius);
    ChangeBatteryVoltageMilliVolt(GetParam().batteryVoltageMilliVolt);

    EXPECT_EQ(GetParam().chargeVoltageLimit, driver::detail::GetChargeVoltageLimitMilliVolt());
}

}} // namespace nnt::psm
