﻿param(
    [Parameter(ValueFromPipelineByPropertyName = $true)]
    [Nintendo.CPU.Profiler.Scripting.NX.ScriptingSampleMode]$SampleMode = [Nintendo.CPU.Profiler.Scripting.NX.ScriptingSampleMode]::InProcess,
    
    [Parameter(ValueFromPipelineByPropertyName = $true)]
    [string]$Platform,
    
    [Parameter(ValueFromPipelineByPropertyName = $true)]
    [string]$BuildType
)

. "$([Nintendo.CPU.Profiler.Scripting.ScriptingCore]::ScriptDirectory)/testProfiler_Common.ps1"

write-output "Starting testProfiler_SystemProcess"

function InvalidTest()
{
    write-error "Test incompatible with in-process profiling"
    return $true
}

profiler-exit 0 -WarningsAsErrors

if ($SampleMode -eq [Nintendo.CPU.Profiler.Scripting.NX.ScriptingSampleMode]::InProcess)
{
    RunTest("InvalidTest")
    TestsFinished
}

$spec = "NX-NXFP2-a"
if ($Platform -eq "NX64")
{
    $spec += "64"
}
elseif ($Platform -eq "NX32")
{
    $spec += "32"
}
else
{
    write-error "Invalid Platform: $Platform"
    exit
}

$synced = $false
for ($loop = 0; ($loop -lt 2) -and ($synced -eq $false); ++$loop)
{
    write-output "Waiting for devkit..."
    profiler-waitfor CanSync
    write-output "Connecting to devkit..."
    $connected = profiler-connect
    if ($connected -eq $false)
    {
        write-error "Could not Connect"
        exit
    }
    
    sleep 1
    
    $nssFile = Resolve-Path "$([Nintendo.CPU.Profiler.Scripting.ScriptingCore]::ScriptDirectory)/../../../Outputs/$spec/Tests/testProfiler_SystemProcessIntegration/$BuildType/testprofiler_SystemProcessIntegration.nss"
    write-output "Using NSS: $nssFile"
    
    write-output "Setting scenario"
    profiler-nx-scenario AttachToProgramId -NssFile $nssFile -Autofill -ProgramId 0
    write-output "Attempting to Sync..."
    $synced = profiler-sync
} 
if ($synced -eq $false)
{
    write-error "Could not Sync"
    exit
}
write-output "Synced!"

function Test()
{
    $containedFailure = $false
    
    profiler-waitfor ReadyToProfile
    sleep 1
    profiler-nx-cores 3
    profiler-start Sampled
    sleep 1
    profiler-stop
    
    profiler-waitfor ReadyToProfile
    WaitForCheckersToFinish
    
    $functionList = profiler-copy Functions
    if ($functionList.Contains("BusyWork") -eq $false)
    {
        WriteError "Could not find BusyWork function"
        $containedFailure = $true
    }

    if ([Nintendo.SDSG.Utilities.Logging]::Warnings.Count -gt 0)
    {
        WriteError "Generated a warning"        
        $containedFailure = $true
    }

    return $containedFailure
}

RunTest("Test")

profiler-unsync

write-output "Unsynced from devkit"

TestsFinished
