﻿# --------------------------------------------------------------------------------
# Copyright (C)Nintendo. All rights reserved.
#
# These coded instructions, statements, and computer programs contain proprietary
# information of Nintendo and/or its licensed developers and are protected by
# national and international copyright laws. They may not be disclosed to third
# parties or copied or duplicated in any form, in whole or in part, without the
# prior written consent of Nintendo.
#
# The content herein is highly confidential and should be handled accordingly.
# --------------------------------------------------------------------------------

# Usage: ModifyTestSystemProcess.ps1 -Source [Source] -Destination [Destination]

Param
(
    [Parameter(Mandatory=$true)]
    [string] $Source,

    [Parameter(Mandatory=$true)]
    [string] $Destination
)

[xml]$descFile = Get-Content -Path $Source

$minCoreNodes = $descFile.SelectNodes("//MinCoreNumber")
foreach ($node in $minCoreNodes)
{
    $node.InnerText = "3"
}

$mainThreadCoreNodes = $descFile.SelectNodes("//MainThreadCoreNumber")
foreach ($node in $mainThreadCoreNodes)
{
    $node.InnerText = "3"
}

$descFile.Save($Destination)
