﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nnt.h>

#include <nn/os.h>

#include <nn/prepo.h>
#include <nn/prepo/prepo_ApiAdmin.h>
#include <nn/prepo/prepo_ApiConfig.h>
#include <nn/prepo/prepo_Result.h>
#include <nn/prepo/prepo_SystemPlayReport.h>

#include <nn/util/util_FormatString.h>

namespace
{
    void Save8kReport()
    {
        nn::prepo::SystemPlayReport report;

        static nn::Bit8 buffer[nn::prepo::PlayReport::BufferSizeMax];
        report.SetBuffer(buffer, sizeof (buffer));

        nn::ApplicationId applicationId = {0x0123456789abcdef};
        NNT_EXPECT_RESULT_SUCCESS(report.SetApplicationId(applicationId));

        char eventId[nn::prepo::EventIdLengthMax + 1] = {};
        nn::util::SNPrintf(eventId, sizeof (eventId), "test_file_size_boundary");
        NNT_EXPECT_RESULT_SUCCESS(report.SetEventId(eventId));

        char key[nn::prepo::KeyLengthMax + 1] = {};
        char value[nn::prepo::StringValueLengthMax + 1] = {};

        const auto keyValueCount = 62;

        for (auto i = 1; i <= keyValueCount - 1; i++)
        {
            nn::util::SNPrintf(key, sizeof (key), "key_00000000000000000000000000000000000000000000000000000000%03d", i);
            nn::util::SNPrintf(value, sizeof (value), "value_000000000000000000000000000000000000000000000000000000%03d", i);
            NNT_EXPECT_RESULT_SUCCESS(report.Add(key, value));
        }

        nn::util::SNPrintf(key, sizeof (key), "key_%03d", keyValueCount);
        nn::util::SNPrintf(value, sizeof (value), "value_%03d", keyValueCount);
        NNT_EXPECT_RESULT_SUCCESS(report.Add(key, value));

        NNT_EXPECT_RESULT_SUCCESS(report.Save());
    }
}

TEST(testPrepo_FileSizeBoundary, Initialize)
{
    // TODO: NSA ID が存在しないことのチェック。// NSA ID が存在しないときの、レポートファイルのサイズを前提としているため。

    nn::os::SleepThread(nn::TimeSpan::FromSeconds(10)); // pdm がプレイレポートを作成するため、少し待ってからストレージをクリアする。
    NNT_ASSERT_RESULT_SUCCESS(nn::prepo::ClearStorage());

    NNT_ASSERT_RESULT_SUCCESS(nn::prepo::SetUserAgreementCheckEnabled(false));
}

TEST(testPrepo_FileSizeBoundary, Main)
{
    // ファイルサイズが上限に達する前に、アップロードされることがあるため、多目に書き込む。
    for (auto i = 0; i < 32; i++)
    {
        Save8kReport();
    }

    nn::os::SleepThread(nn::TimeSpan::FromSeconds(10)); // アップロードされるのを待つ。
}

TEST(testPrepo_FileSizeBoundary, Finalize)
{
    NNT_ASSERT_RESULT_SUCCESS(nn::prepo::ClearStorage()); // テストで大量に作成したプレイレポートを削除する。

    NNT_ASSERT_RESULT_SUCCESS(nn::prepo::SetUserAgreementCheckEnabled(true));
}
