<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Create Nsp

    .DESCRIPTION
        Create Nsp
#>

[CmdletBinding()]
Param(
    [parameter(Mandatory=$true)]
    [string]$ApplicationId = "",

    [parameter(Mandatory=$true)]
    [string]$OutputDirectory = "",

    [parameter(Mandatory=$true)]
    [string]$FileName = ""

)

$ErrorActionPreference = "Stop"

$scriptPath = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [IO.Path]::GetDirectoryName($ScriptPath)
$sigloRoot = (Join-Path $scriptDirectoryPath ../../.. | Resolve-Path).Path
$moduleRoot = "${sigloRoot}\Integrate\Scripts\Modules\"

Import-Module "${moduleRoot}\Path"
Import-Module "${moduleRoot}\Utility"

$MakeTestApplication = "$sigloRoot/Tools/CommandLineTools/MakeTestApplication/MakeTestApplication.exe"
$AuthoringTool = "$sigloRoot/Tools/CommandLineTools/AuthoringTool/AuthoringTool.exe"

$tempDir = Join-Path $OutputDirectory ([System.IO.Path]::GetRandomFileName())
New-Item -ItemType Directory $tempDir -Force
$workDir = Join-Path $tempDir "working"

# nspの生成
New-Item -ItemType Directory $workDir -Force
Invoke-CriticalCommand "& $MakeTestApplication --work-directory $workDir --ticket --id $ApplicationId -o $tempDir --output-file-name $FileName"

$extractedDir = "$tempDir/Extracted"
# 展開
Invoke-CriticalCommand "& $AuthoringTool extractnsp $tempDir/$FileName.nsp -o $extractedDir"

# チケットを削除
Remove-Item "$extractedDir/*.tik"
Remove-Item "$extractedDir/*.cert"

# nspuの生成
Invoke-CriticalCommand "& $AuthoringTool createfs --format partitionfs -o $OutputDirectory/$FileName.nspu $extractedDir"

# パッチの生成
New-Item -ItemType Directory $workDir -Force
Invoke-CriticalCommand "& $MakeTestApplication  --work-directory $workDir --id $ApplicationId -o $OutputDirectory --output-file-name $FileName.patch --type Patch --ver 1 --original-application $tempDir/$FileName.nsp"
