﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <getopt.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_Abort.h>
#include <nn/spsm/spsm_Api.h>
#include <nnt/nnt_Argument.h>

namespace {

    bool ParseProgramOption(bool* pOutIsRebooting)
    {
        int argc = nnt::GetHostArgc();
        char** argv = nnt::GetHostArgv();
        int option;

        // default
        *pOutIsRebooting = false;

        while ((option = getopt(argc, argv, "r")) != -1)
        {
            switch(option)
            {
            case 'r':
                *pOutIsRebooting = true;
                break;
            default:
                NN_LOG("Error: detected unknown option:[%c].\n", option);
                return false;
            }
        }
        return true;
    }

}

extern "C" void nnMain()
{
    bool isRebooting = false;
    if (!ParseProgramOption(&isRebooting))
    {
        NN_LOG("Options:\n"
            "-r : Reboot system after shutdown.\n");
        NN_ABORT("Aborting test.");
    }

    nn::spsm::Initialize();
    if (isRebooting)
    {
        NN_LOG("Reboot will start in 2 seconds.\n");
        nn::os::SleepThread(nn::TimeSpan::FromSeconds(2));
        nn::spsm::RebootSystem();
        // NEVER REACHED HERE
    }
    else
    {
        NN_LOG("Shutdown will start in 2 seconds.\n");
        nn::os::SleepThread(nn::TimeSpan::FromSeconds(2));
        nn::spsm::ShutdownSystem();
        // NEVER REACHED HERE
    }
}
