﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/oe.h>
#include <nn/oe/oe_BatteryDrainingPerformance.h>

#include <nnt/nntest.h>

#include "testOe_Init.h"

// SDK 使用者に公開されている性能のみをテストする
// 互換性テスト向けの ConfigInfo のリスト
// したがって nn/oe/oe_HiddenPerformance.h は include しない

namespace nnt { namespace oe {

const ConfigInfo ConfigInfoListForSdkUsers[] =
{
    { nn::oe::PerformanceMode_Boost,  nn::oe::PerformanceConfiguration_Cpu1020MhzGpu768MhzEmc1600Mhz, 1020000000, 768000000, 1600000000 },
    { nn::oe::PerformanceMode_Normal, nn::oe::PerformanceConfiguration_Cpu1020MhzGpu307MhzEmc1331Mhz, 1020000000, 307200000, 1331200000 },
    { nn::oe::PerformanceMode_Normal, nn::oe::PerformanceConfiguration_Cpu1020MhzGpu384MhzEmc1331Mhz, 1020000000, 384000000, 1331200000 },
    { nn::oe::PerformanceMode_Normal, nn::oe::PerformanceConfiguration_Cpu1020MhzGpu460MhzEmc1331Mhz, 1020000000, 460800000, 1331200000 }, // 一部開発者のみに公開
};

class PerformanceConfigurationTestForSdkUsers : public ::testing::TestWithParam<nnt::oe::ConfigInfo> { };

}} // namespace nnt::oe
