﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/oe.h>
#include <nn/oe/oe_BatteryDrainingPerformance.h>
#include <nn/oe/oe_HiddenPerformance.h>

#include <nnt/nntest.h>

#include "testOe_Init.h"

NN_DISABLE_WARNING_DEPRECATED_DECLARATIONS

namespace nnt { namespace oe {

const ConfigInfo ConfigInfoList[] =
{
    { nn::oe::PerformanceMode_Boost,  nn::oe::PerformanceConfiguration_Cpu1020MhzGpu768MhzEmc1600Mhz, 1020000000, 768000000, 1600000000 },
    { nn::oe::PerformanceMode_Normal, nn::oe::PerformanceConfiguration_Cpu1020MhzGpu307MhzEmc1600Mhz, 1020000000, 307200000, 1600000000 }, // 非公開・非サポートだが使用可能
    { nn::oe::PerformanceMode_Normal, nn::oe::PerformanceConfiguration_Cpu1020MhzGpu307MhzEmc1331Mhz, 1020000000, 307200000, 1331200000 },
    { nn::oe::PerformanceMode_Invalid, nn::oe::PerformanceConfiguration_Cpu1020MhzGpu307MhzEmc1065Mhz, 1020000000, 307200000, 1065600000 }, // 非公開・非サポート・使用不可能
    { nn::oe::PerformanceMode_Normal, nn::oe::PerformanceConfiguration_Cpu1020MhzGpu384MhzEmc1331Mhz, 1020000000, 384000000, 1331200000 },
    { nn::oe::PerformanceMode_Normal, nn::oe::PerformanceConfiguration_Cpu1020MhzGpu460MhzEmc1600Mhz, 1020000000, 460800000, 1600000000 }, // 非公開・非サポートだが使用可能
    { nn::oe::PerformanceMode_Normal, nn::oe::PerformanceConfiguration_Cpu1020MhzGpu460MhzEmc1331Mhz, 1020000000, 460800000, 1331200000 }, // 一部開発者のみに公開
    { nn::oe::PerformanceMode_Normal, nn::oe::PerformanceConfiguration_Cpu1020MhzGpu384MhzEmc1600Mhz, 1020000000, 384000000, 1600000000 }, // 非公開・非サポートだが使用可能
    { nn::oe::PerformanceMode_Invalid, nn::oe::PerformanceConfiguration_Cpu1020MhzGpu384MhzEmc1065Mhz, 1020000000, 384000000, 1065600000 }, // 非公開・非サポート・使用不可能
};

class PerformanceConfigurationTest : public ::testing::TestWithParam<nnt::oe::ConfigInfo> { };

}} // namespace nnt::oe
