﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>

#include <nnt/nnt_Argument.h>

#include "../ApmCommon/SocThermAccessor.h"

extern "C" void nnMain()
{
    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    // デフォルトは OC2 の極性を ActiveHigh にして OC2 スロットリングと割り込みをトリガする設定です。
    nne::soctherm::OcAlarm alarm = nne::soctherm::OcAlarm_Oc2;
    bool activeHigh = true;

    // 引数で対象を変更可能にしていますが使う機会は無いかもしれません。
    if ( argc >= 1 )
    {
        if ( strcmp(*argv, "oc1") == 0 )
        {
            alarm = nne::soctherm::OcAlarm_Oc1;
        }
        else if ( strcmp(*argv, "oc2") == 0 )
        {
            alarm = nne::soctherm::OcAlarm_Oc2;
        }
    }
    if ( argc >= 2 )
    {
        if ( strcmp(*(argv + 1), "activehigh") == 0 )
        {
            activeHigh = true;
        }
        else if ( strcmp(*(argv + 1), "activelow") == 0 )
        {
            activeHigh = false;
        }
    }

    NN_LOG("nnt::soctherm::SetOcAlarmPolarity(%d, %d)", alarm, activeHigh);

    // 極性を変化させることで入力の変化の代替とします。
    nnt::soctherm::SetOcAlarmPolarity(alarm, activeHigh);
}
