﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/pcv/pcv.h>
#include <nn/nn_Common.h>
#include <nnt/nntest.h>

class SetVoltageEnabledTest : public ::testing::TestWithParam<nn::pcv::PowerDomain>{};

// All power domains?
const nn::pcv::PowerDomain supportedPDs[] =
    {
        // Insert supported PowerDomains that can Set voltage enabled
        nn::pcv::PowerDomain_Max77620_Ldo2,
    };

INSTANTIATE_TEST_CASE_P(SetVoltageEnabledModules,
    SetVoltageEnabledTest,
    ::testing::ValuesIn(supportedPDs));

TEST_P(SetVoltageEnabledTest, DISABLED_PowerDomain)
{
    ASSERT_TRUE(nn::pcv::IsInitialized());

    bool       enabled;
    nn::Result result;

    result = nn::pcv::GetVoltageEnabled(&enabled, static_cast<nn::pcv::PowerDomain>(GetParam()));
    EXPECT_TRUE(result.IsSuccess());
    if (!result.IsSuccess())
    {
        NN_LOG("Module: %3d\n", result.GetModule());
        NN_LOG("Description: %3d\n", result.GetDescription());
    }

    // Toggle Enable
    result = nn::pcv::SetVoltageEnabled(static_cast<nn::pcv::PowerDomain>(GetParam()), !enabled);

    EXPECT_TRUE(result.IsSuccess());
    if (!result.IsSuccess())
    {
        NN_LOG("Module: %3d\n", result.GetModule());
        NN_LOG("Description: %3d\n", result.GetDescription());
    }

    // Verify
    bool actualEnabled = enabled;
    result = nn::pcv::GetVoltageEnabled(&actualEnabled, static_cast<nn::pcv::PowerDomain>(GetParam()));
    EXPECT_TRUE(result.IsSuccess());
    if (!result.IsSuccess())
    {
        NN_LOG("Module: %3d\n", result.GetModule());
        NN_LOG("Description: %3d\n", result.GetDescription());
    }
    EXPECT_EQ(!enabled, actualEnabled);

    // Return to inital state
    result = nn::pcv::SetVoltageEnabled(static_cast<nn::pcv::PowerDomain>(GetParam()), enabled);
    if (!result.IsSuccess())
    {
        NN_LOG("Module: %3d\n", result.GetModule());
        NN_LOG("Description: %3d\n", result.GetDescription());
    }

    // Verify
    actualEnabled = !enabled;
    result = nn::pcv::GetVoltageEnabled(&actualEnabled, static_cast<nn::pcv::PowerDomain>(GetParam()));
    EXPECT_TRUE(result.IsSuccess());
    if (!result.IsSuccess())
    {
        NN_LOG("Module: %3d\n", result.GetModule());
        NN_LOG("Description: %3d\n", result.GetDescription());
    }
    EXPECT_EQ(enabled, actualEnabled);
}

TEST_F(SetVoltageEnabledTest, InvalidPowerDomain)
{
    ASSERT_TRUE(nn::pcv::IsInitialized());

    nn::Result result;
    result = nn::pcv::SetVoltageEnabled(nn::pcv::PowerDomain_NumPowerDomain, true);
    EXPECT_FALSE(result.IsSuccess());
    NN_LOG("Module: %3d\n", result.GetModule());
    NN_LOG("Description: %3d\n", result.GetDescription());
}
