﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/pcv/pcv.h>
#include <nnt/nntest.h>
#include "../Common/ModuleNames.h"
#include "../Common/ModuleInfo.h"

using namespace nnt::pcv;

namespace
{
    const ModuleInfo setResetModules[] =
    {
        { nn::pcv::Module_Ape,               NonDiscrete,      Exact },
    };

    class SetResetTest : public ::testing::TestWithParam<nnt::pcv::ModuleInfo>{};

    INSTANTIATE_TEST_CASE_P(SetResetModules, SetResetTest, testing::ValuesIn(setResetModules));
}

TEST_P(SetResetTest, Module)
{
    // Pcv library should already be initialized
    ASSERT_TRUE(nn::pcv::IsInitialized());

    nn::pcv::Module module = GetParam().name;

    // assert
    auto r = nn::pcv::SetReset(module, true);
    EXPECT_TRUE(r.IsSuccess());

    // de-assert
    r = nn::pcv::SetReset(module, false);
    EXPECT_TRUE(r.IsSuccess());
}


TEST_F(SetResetTest, InvalidModule)
{
    // Pcv library should already be initialized
    ASSERT_TRUE(nn::pcv::IsInitialized());

    NN_LOG("\n\n%s\n", __FUNCTION__);

    nn::Result result = nn::pcv::SetReset(nn::pcv::Module_NumModule, true);
    ASSERT_FALSE(result.IsSuccess());

    result = nn::pcv::SetReset(nn::pcv::Module_NumModule, false);
    ASSERT_FALSE(result.IsSuccess());

}
