﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>

#include <nn/os.h>

#include <nn/pcv/pcv.h>

#include <nnt/nntest.h>

#include "../Common/IsValidPowerControlTarget.h"

class IsPoweredOnTest : public ::testing::TestWithParam<nn::pcv::PowerControlTarget>{};

const nn::pcv::PowerControlTarget SupportedPowerControlTargets[] =
{
    nn::pcv::PowerControlTarget_SdCard,
    nn::pcv::PowerControlTarget_Hdmi,
    nn::pcv::PowerControlTarget_SioMcu,
    nn::pcv::PowerControlTarget_SioMcuA,
};

INSTANTIATE_TEST_CASE_P(IsPoweredOnModules, IsPoweredOnTest, ::testing::ValuesIn(SupportedPowerControlTargets));

TEST_P(IsPoweredOnTest, SupportedPowerControlTarget)
{
    ASSERT_TRUE(nn::pcv::IsInitialized());

    bool isPoweredOn;

    auto result = nn::pcv::IsPoweredOn(&isPoweredOn, GetParam());
    if ( nnt::pcv::IsValidPowerControlTarget(GetParam()) )
    {
        EXPECT_TRUE(result.IsSuccess());
    }
    else
    {
        EXPECT_FALSE(result.IsSuccess());
        NN_LOG("Module: %3d\n", result.GetModule());
        NN_LOG("Description: %3d\n", result.GetDescription());
    }

    // 期待値は設定しない（設定するならば動作モード分岐等が必要）
    NN_UNUSED(isPoweredOn);
}

TEST_F(IsPoweredOnTest, UnsupportedPowerControlTarget)
{
    ASSERT_TRUE(nn::pcv::IsInitialized());

    bool isPoweredOn;

    auto invalidResult = nn::pcv::IsPoweredOn(&isPoweredOn, nn::pcv::PowerControlTarget_NumPowerControlTarget);
    ASSERT_FALSE(invalidResult.IsSuccess());

    NN_LOG("Module: %3d\n", invalidResult.GetModule());
    NN_LOG("Description: %3d\n", invalidResult.GetDescription());

    // 期待値は設定しない
    NN_UNUSED(isPoweredOn);
}
