﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/pcv/pcv.h>
#include <nn/nn_Common.h>
#include <nnt/nntest.h>

#include "../Common/IsValidPowerDomain.h"

class GetVoltageRangeTest : public ::testing::TestWithParam<int>{};

INSTANTIATE_TEST_CASE_P(AllPowerDomains,
    GetVoltageRangeTest,
    ::testing::Range(0, static_cast<int>(nn::pcv::PowerDomain_NumPowerDomain)));

// Disabled: GetVoltageRange reutrns result not implemented 2/8/2016
TEST_P(GetVoltageRangeTest, PowerDomain)
{
    ASSERT_TRUE(nn::pcv::IsInitialized());

    if ( !nnt::pcv::IsValidPowerDomain(static_cast<nn::pcv::PowerDomain>(GetParam())) )
    {
        return;
    }

    bool       enabled;
    nn::Result result;
    result = nn::pcv::GetVoltageEnabled(&enabled, static_cast<nn::pcv::PowerDomain>(GetParam()));
    EXPECT_TRUE(result.IsSuccess());
    if (!result.IsSuccess())
    {
            NN_LOG("Module: %3d\n", result.GetModule());
            NN_LOG("Description: %3d\n", result.GetDescription());
    }
    if (enabled)
    {
        nn::pcv::MicroVolt minVoltage, maxVoltage, stepVoltage = 0;
        result = nn::pcv::GetVoltageRange(&minVoltage, &maxVoltage, &stepVoltage, static_cast<nn::pcv::PowerDomain>(GetParam()));
        EXPECT_TRUE(result.IsSuccess());
        if (!result.IsSuccess())
        {
            NN_LOG("Module: %3d\n", result.GetModule());
            NN_LOG("Description: %3d\n", result.GetDescription());
        }
        EXPECT_GE(maxVoltage, minVoltage);
        NN_LOG("PowerDomain %2d: min=%10d uV, max=%10d uV, step=%10d uV\n",
               GetParam(), minVoltage, maxVoltage, stepVoltage);
    }
    else
    {
        NN_LOG("PowerDomain %2d: not enabled\n", GetParam());
    }
}

TEST_F(GetVoltageRangeTest, InvalidPowerDomain)
{
    ASSERT_TRUE(nn::pcv::IsInitialized());

    nn::Result result;
    nn::pcv::MicroVolt minVoltage, maxVoltage, stepVoltage = 0;
    result = nn::pcv::GetVoltageRange(&minVoltage, &maxVoltage, &stepVoltage, nn::pcv::PowerDomain_NumPowerDomain);
    EXPECT_FALSE(result.IsSuccess());
    NN_LOG("Module: %3d\n", result.GetModule());
    NN_LOG("Description: %3d\n", result.GetDescription());
}
