﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/pcv/pcv.h>
#include <nn/nn_Common.h>
#include <nnt/nntest.h>

#include "../Common/IsValidPowerDomain.h"

class GetVoltageEnabledTest : public ::testing::TestWithParam<int>{};

INSTANTIATE_TEST_CASE_P(AllPowerDomains,
    GetVoltageEnabledTest,
    ::testing::Range(0, static_cast<int>(nn::pcv::PowerDomain_NumPowerDomain)));

// Regulator API session bug causes GPU calls to fail when re-running tests
TEST_P(GetVoltageEnabledTest, PowerDomain)
{
    ASSERT_TRUE(nn::pcv::IsInitialized());

    if ( !nnt::pcv::IsValidPowerDomain(static_cast<nn::pcv::PowerDomain>(GetParam())) )
    {
        return;
    }

    bool       enabled;
    nn::Result result;
    result = nn::pcv::GetVoltageEnabled(&enabled, static_cast<nn::pcv::PowerDomain>(GetParam()));
    EXPECT_TRUE(result.IsSuccess());
    if (!result.IsSuccess())
    {
        NN_LOG("Module: %3d\n", result.GetModule());
        NN_LOG("Description: %3d\n", result.GetDescription());
    }
    if (enabled)
    {
        NN_LOG("PowerDomain %d: enabled\n", GetParam());
    }
    else
    {
        NN_LOG("PowerDomain %d: not enabled\n", GetParam());
    }
}

TEST_F(GetVoltageEnabledTest, InvalidPowerDomain)
{
    ASSERT_TRUE(nn::pcv::IsInitialized());

    bool       enabled;
    nn::Result result;
    result = nn::pcv::GetVoltageEnabled(&enabled, nn::pcv::PowerDomain_NumPowerDomain);
    EXPECT_FALSE(result.IsSuccess());
    NN_LOG("Module: %3d\n", result.GetModule());
    NN_LOG("Description: %3d\n", result.GetDescription());
}
