﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/pcv/pcv.h>
#include <nn/nn_Common.h>
#include <nnt/nntest.h>

#include "../Common/IsValidPowerDomain.h"

class GetVoltageValueTest : public ::testing::TestWithParam<int>{};

INSTANTIATE_TEST_CASE_P(AllPowerDomains,
    GetVoltageValueTest,
    ::testing::Range(0, static_cast<int>(nn::pcv::PowerDomain_NumPowerDomain)));

// Regulator API session bug causes GPU calls to fail when re-running tests
TEST_P(GetVoltageValueTest, PowerDomain)
{
    ASSERT_TRUE(nn::pcv::IsInitialized());

    if ( !nnt::pcv::IsValidPowerDomain(static_cast<nn::pcv::PowerDomain>(GetParam())) )
    {
        return;
    }

    nn::Result getVolatageValueResult;
    nn::pcv::MicroVolt voltage = 0;

    getVolatageValueResult = nn::pcv::GetVoltageValue(&voltage, static_cast<nn::pcv::PowerDomain>(GetParam()));
    EXPECT_TRUE(getVolatageValueResult.IsSuccess());
    if (!getVolatageValueResult.IsSuccess())
    {
        NN_LOG("Module: %3d\n", getVolatageValueResult.GetModule());
        NN_LOG("Description: %3d\n", getVolatageValueResult.GetDescription());
    }

    NN_LOG("PowerDomain %2d: Voltage = %10d uV\n", GetParam(), voltage);
}

TEST_F(GetVoltageValueTest, InvalidPowerDomain)
{
    ASSERT_TRUE(nn::pcv::IsInitialized());
    nn::Result invalidResult;
    nn::pcv::MicroVolt voltage = 0;

    invalidResult = nn::pcv::GetVoltageValue(&voltage, nn::pcv::PowerDomain_NumPowerDomain);
    ASSERT_FALSE(invalidResult.IsSuccess());
    NN_LOG("Module: %3d\n", invalidResult.GetModule());
    NN_LOG("Description: %3d\n", invalidResult.GetDescription());
}

TEST_F(GetVoltageValueTest, DISABLED_NullVoltage)
{
    ASSERT_TRUE(nn::pcv::IsInitialized());
    nn::Result invalidResult;
    nn::pcv::MicroVolt *voltage = NULL;

    invalidResult = nn::pcv::GetVoltageValue(voltage, static_cast<nn::pcv::PowerDomain>(0));
    ASSERT_FALSE(invalidResult.IsSuccess());
    NN_LOG("Module: %3d\n", invalidResult.GetModule());
    NN_LOG("Description: %3d\n", invalidResult.GetDescription());

}

