﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/pcv/pcv.h>
#include <nn/nn_Common.h>
#include <nnt/nntest.h>
#include "../Common/ModuleInfo.h"
#include "../Common/ModuleNames.h"

using namespace nnt::pcv;

class GetClockRateTest : public ::testing::TestWithParam<nn::pcv::Module>{};
const nn::pcv::Module getStateModules[] =
    {
        nn::pcv::Module_Cpu,
        nn::pcv::Module_Gpu,
        nn::pcv::Module_I2s1,
        nn::pcv::Module_I2s2,
        nn::pcv::Module_I2s3,
        nn::pcv::Module_Pwm,
        nn::pcv::Module_I2c1,
        nn::pcv::Module_I2c2,
        nn::pcv::Module_I2c3,
        nn::pcv::Module_I2c4,
        nn::pcv::Module_I2c5,
        nn::pcv::Module_I2c6,
        nn::pcv::Module_Spi1,
        nn::pcv::Module_Spi2,
        nn::pcv::Module_Spi3,
        nn::pcv::Module_Spi4,
        nn::pcv::Module_Disp1,
        nn::pcv::Module_Disp2,
        //nn::pcv::Module_Isp,
        //nn::pcv::Module_Vi,
        nn::pcv::Module_Sdmmc1,
        nn::pcv::Module_Sdmmc2,
        nn::pcv::Module_Sdmmc3,
        nn::pcv::Module_Sdmmc4,
        //nn::pcv::Module_Owr,
        nn::pcv::Module_Csite,
        nn::pcv::Module_Tsec,
        nn::pcv::Module_Mselect,
        nn::pcv::Module_Hda2codec2x,
        nn::pcv::Module_Actmon,
        nn::pcv::Module_I2cSlow,
        nn::pcv::Module_Sor1,
        //nn::pcv::Module_Sata,
        nn::pcv::Module_Hda,
        nn::pcv::Module_XusbCoreHostSrc,
        nn::pcv::Module_XusbFalconSrc,
        nn::pcv::Module_XusbFsSrc,
        nn::pcv::Module_XusbCoreDevSrc,
        nn::pcv::Module_XusbSsSrc,
        nn::pcv::Module_UartA,
        nn::pcv::Module_UartB,
        nn::pcv::Module_UartC,
        nn::pcv::Module_UartD,
        nn::pcv::Module_Hostx,
        nn::pcv::Module_Entropy,
        nn::pcv::Module_SocTherm,
        nn::pcv::Module_Vic,
        nn::pcv::Module_Nvenc,
        nn::pcv::Module_Nvjpg,
        nn::pcv::Module_Nvdec,
        nn::pcv::Module_Qspi,
        //nn::pcv::Module_ViI2c,
        nn::pcv::Module_Tsecb,
        nn::pcv::Module_Ape,
        nn::pcv::Module_AudioDsp,
        nn::pcv::Module_AudioUart,
        nn::pcv::Module_Emc,
        nn::pcv::Module_Plle,
        nn::pcv::Module_PlleHwSeq,
        nn::pcv::Module_Dsi,
        nn::pcv::Module_Maud,
        nn::pcv::Module_Dpaux1,
        nn::pcv::Module_MipiCal,
        nn::pcv::Module_UartFstMipiCal,
        nn::pcv::Module_Osc,
        nn::pcv::Module_SysBus,
        nn::pcv::Module_SorSafe,
        nn::pcv::Module_XusbSs,
        nn::pcv::Module_XusbHost,
        nn::pcv::Module_XusbDevice,
        nn::pcv::Module_Extperiph1,
        nn::pcv::Module_Ahub,
        nn::pcv::Module_Hda2hdmicodec,
        nn::pcv::Module_Gpuaux,
        nn::pcv::Module_UsbD,
        nn::pcv::Module_Usb2,
        nn::pcv::Module_Pcie,
        nn::pcv::Module_Afi,
        nn::pcv::Module_PciExClk,
        nn::pcv::Module_PExUsbPhy,
        nn::pcv::Module_XUsbPadCtl,
        nn::pcv::Module_Apbdma,
        nn::pcv::Module_Usb2TrkClk,
        nn::pcv::Module_XUsbIoPll,
        nn::pcv::Module_XUsbIoPllHwSeq,
    };

INSTANTIATE_TEST_CASE_P(GetClockModules, GetClockRateTest, testing::ValuesIn(getStateModules));

TEST_P(GetClockRateTest, Module)
{
    // Pcv library should already be initialized
    ASSERT_TRUE(nn::pcv::IsInitialized());

    nn::pcv::ClockHz clockRate = 0;
    nn::Result getClockRateResult = nn::pcv::GetClockRate(&clockRate, GetParam());
    EXPECT_TRUE(getClockRateResult.IsSuccess());

    NN_LOG("Module: %s\n", GetModuleName(GetParam()));
    NN_LOG("\tClock frequency: %.2f MHz\n\n", clockRate / (1000.0 * 1000.0));
}

// Invalid module passed in
TEST_F(GetClockRateTest, InvalidModule)
{
    ASSERT_TRUE(nn::pcv::IsInitialized());

    nn::pcv::ClockHz clockRate = 0;

    nn::pcv::Module errorMod = nn::pcv::Module_NumModule;

    nn::Result invalidModuleResult = nn::pcv::GetClockRate(&clockRate, errorMod);
    EXPECT_FALSE(invalidModuleResult.IsSuccess());
}

TEST_F(GetClockRateTest, DISABLED_NULLState)
{
    ASSERT_TRUE(nn::pcv::IsInitialized());

    nn::pcv::ClockHz *pClockRate = NULL;
    nn::Result r = nn::pcv::GetClockRate(pClockRate, nn::pcv::Module_Cpu);
    ASSERT_FALSE(r.IsSuccess());
}
