﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nnt/result/testResult_Assert.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/pctl/pctl_Api.h>
#include <nn/pctl/pctl_ApiSystem.h>
#include <nn/pctl/pctl_ApiForAuthentication.h>

TEST(AccessControlGeneralAndSystemAndAuth, TestSetSafetyLevel)
{
    auto level = nn::pctl::GetSafetyLevel();
    // requires 'pctl:s'
    nn::pctl::SetSafetyLevel(level);
}

TEST(AccessControlGeneralAndSystemAndAuth, TestPinCode)
{
    // requires 'pctl:a'
    nn::pctl::SetPinCode("0123");
    EXPECT_TRUE(nn::pctl::IsRestrictionEnabled());
    NNT_EXPECT_RESULT_SUCCESS(nn::pctl::UnlockSystemSettingsRestriction("0123"));
    nn::pctl::RevertRestrictedSystemSettingsEntered();
    nn::pctl::SetPinCode(nullptr);
}
