﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
//#include <nn/applet.h>

#include "os_DemoUtil.h"

extern void MemoryDemo();
extern void ThreadDemo();
extern void MutexDemo();
extern void SemaphoreDemo();
extern void EventDemo();
extern void TimerDemo();
extern void AlarmDemo();
extern void MessageQueueDemo();
extern void TickDemo();

//  os_Demo OS 系ライブラリのデモプログラムです。
//  MemoryBlock, Thread, Mutex, Semaphore, Event, Timer, Tick, Alarm,
//  MessageQueue の動作を示します。


//extern "C" void nninitStartUp(void)
//{
//}

extern "C" void nnMain()
{
#if 0
    // ホームメニューからも実行できるよう nn::applet::Enable() のみ呼ぶ
    // ホームメニュー遷移や電源ボタンクリック、スリープには非対応
    nn::applet::Enable();
#endif

    NN_LOG("nnMain starts.\n");

    DemoUtil::DumpObjectCounts();

    //----------------------------------------------------------------
    // メモリのデモ
    MemoryDemo();
    NN_LOG("----\n");

    // スレッドのデモ
    ThreadDemo();
    NN_LOG("----\n");

    // ミューテックスのデモ
    MutexDemo();
    NN_LOG("----\n");

    // セマフォのデモ
    SemaphoreDemo();
    NN_LOG("----\n");

    // イベントのデモ
    EventDemo();
    NN_LOG("----\n");

    // タイマーのデモ
    TimerDemo();
    NN_LOG("----\n");

    // チックのデモ
    TickDemo();
    NN_LOG("----\n");

    // アラームのデモ
    AlarmDemo();
    NN_LOG("----\n");

    // ブロッキングキューのデモ
    MessageQueueDemo();
    NN_LOG("----\n");
    //----------------------------------------------------------------

    DemoUtil::DumpObjectCounts();

    NN_LOG("*** End of demos ***\n");

#if 0
    while(true){}
#endif
}

