﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>

//  Siglo で Alarm が実装された時用にコードを残しておく

#if 0
/*!
  @brief        AlarmDemoで使われるアラームハンドラで、下記の処理を行います。

                非キャンセル時は文字列を出力します。
                キャンセル時は文字列を出力し、キャンセル完了のイベントを発生させます。

  @param[in]    pEvent      キャンセル完了を通知するイベントです。
  @param[in]    cancelled   キャンセルされたかどうかを表す変数です。

  @return       なし。
*/
void SimpleAlarmHandler(nn::os::Event* pEvent, bool cancelled)
{
    if(cancelled)
    {
        NN_LOG(" Cancelled\n");
        pEvent->Signal();
    }
    else
    {
        NN_LOG(" SimpleAlarmHandler\n");
    }
}

/*!
  @brief        アラームのデモです。

                アラームを設定し、アラームハンドラを実行させます。

  @return       なし。
*/
void AlarmDemo1()
{
    NN_LOG("-- Alarm Demo1 --\n");

    nn::os::Alarm alarm;
    nn::os::Event cancelEvent(false);

    // アラームの初期化
    alarm.Initialize();

    // ワンショットアラームを１秒に設定
    alarm.SetOneShot(nn::fnd::TimeSpan::FromSeconds(1), SimpleAlarmHandler, &cancelEvent);

    NN_LOG("SimpleAlarmHandler will be executed in 1 sec.\n");

    // アラームが設定できるようになるまで待機
    while( !alarm.CanSet() )
    {
        nn::os::Thread::Yield();
    }

    // 周期アラームを設定（最初100ミリ秒、その後200ミリ秒周期）
    alarm.SetPeriodic(nn::fnd::TimeSpan::FromMilliSeconds(100), nn::fnd::TimeSpan::FromMilliSeconds(200), SimpleAlarmHandler, &cancelEvent);

    // １秒間スリープ
    NN_LOG("Sleep 1 sec.\n");
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromSeconds(1));

    // アラームをキャンセル
    alarm.Cancel();

    // キャンセルが完了するまで待機
    cancelEvent.Wait();

    alarm.Finalize();
}
#endif

/*!
  @brief        アラームに関するデモです。

                アラームシステムを初期化し、アラームのデモを実行します。

  @return       なし。
*/
void AlarmDemo()
{
    NN_LOG("*** Alarm Demo starts. ***\n");

#if 1
    NN_LOG("*** There is no Alarm Demo. ***\n");
#else
    nn::os::InitializeAlarmSystem();
    AlarmDemo1();
#endif

    NN_LOG("*** End of Alarm Demo ***\n");
}


