﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../Common/test_Pragma.h"

#include <nn/os/os_Config.h>
#include <nn/nn_SdkText.h>
#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/os/os_SdkRuntimeSupport.h>

#include <nnt/nntest.h>
#include "../Common/test_Helper.h"


namespace nnt { namespace os { namespace runtimeSupport {

//-----------------------------------------------------------------------------

TEST(RuntimeSupport, test_NotifyDebugger)
{
    nnosNotifyDebugger(nnosNotificationReason_CppException, NULL, 0);
    SUCCEED();
}

//-----------------------------------------------------------------------------

TEST(RuntimeSupport, test_BreakPanic)
{
#if 0
    // 実際にデバッガが停止することを確認するためのコード
    nnosBreak(nnosBreakReason_Panic, NULL, 0);
#endif

    // API を使ってビルドが通ることを確認するためのコード
    EXPECT_DEATH_IF_SUPPORTED( nnosBreak(nnosBreakReason_Panic, NULL, 0), "");
}

//-----------------------------------------------------------------------------

TEST(RuntimeSupport, test_BreakAssert)
{
#if 0
    // 実際にデバッガが停止することを確認するためのコード
    nnosBreak(nnosBreakReason_Assert, NULL, 0);
#endif

    // API を使ってビルドが通ることを確認するためのコード
    EXPECT_DEATH_IF_SUPPORTED( nnosBreak(nnosBreakReason_Assert, NULL, 0), "");
}

//-----------------------------------------------------------------------------

}}} // namespace nnt::os::runtimeSupport

