﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/diag/diag_AbortObserver.h>
#include <nnt/nntest.h>
#include <cstdlib> // For quick_exit

static const int ThreadCount = 90;
static NN_OS_ALIGNAS_THREAD_STACK uint8_t s_Stacks[ThreadCount][4096];
static nn::os::ThreadType s_Threads[ThreadCount];

void DummyThreadFunc(void*)
{
    for (;;)
    {}
}

static const int TriggerThreadIndex = 30;
void ThreadStarterFunc(void*)
{
    nn::os::WaitThread(&s_Threads[TriggerThreadIndex]);

    // Thread is signaled -> process switched to TERMINATED state and started to terminate threads
    for (int k = 0; k < ThreadCount; k++)
    {
        if (k == TriggerThreadIndex)
        {
            continue;
        }

        // nn::os::StartThread will abort if svc::StartThread fails
        nn::os::StartThread(&s_Threads[k]);
    }
}

// Prevent SDK abort observers from running IPCs before running svc::Break()
extern "C" void nninitInitializeSdkModule()
{}

extern "C" void nninitFinalizeSdkModule()
{}

TEST(ProcessExit, ProcessExitWithStartThread)
{
    nn::diag::EnableDefaultAbortObserver(false);

    for (int k = 0; k < ThreadCount; k++)
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(
            nn::os::CreateThread(&s_Threads[k], DummyThreadFunc, 0, s_Stacks[k], sizeof(s_Stacks[k]), nn::os::DefaultThreadPriority, 2));
    }

    nn::os::StartThread(&s_Threads[TriggerThreadIndex]);

    nn::os::ThreadType threadStarterHandle;
    static NN_OS_ALIGNAS_THREAD_STACK uint8_t s_ThreadStarterStack[4096];
    // Warning: this thread must be on the same core, otherwise it might be stopped during NN_ABORT() processing in case of failure
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        nn::os::CreateThread(&threadStarterHandle, ThreadStarterFunc, 0, s_ThreadStarterStack, sizeof(s_ThreadStarterStack), nn::os::HighestThreadPriority, nn::os::GetCurrentCoreNumber()));

    nn::os::StartThread(&threadStarterHandle);

    quick_exit(0);
}
