﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>

#include <cstdlib> // For quick_exit
#include <nn/diag/diag_AbortObserver.h>
#include <nnt/nntest.h>

static NN_OS_ALIGNAS_THREAD_STACK uint8_t s_SpinningThreadStack[4096];
static nn::os::ThreadType s_SpinningThread;

void SpinningThreadFunc(void*)
{
    for (;;)
    {
    }
}

void WaiterThreadFunc(void*)
{
    nn::os::WaitThread(&s_SpinningThread);
    // We should never wake up
    NN_ABORT();
}

// Prevent SDK abort observers from running IPCs before running svc::Break()
extern "C" void nninitInitializeSdkModule()
{}

extern "C" void nninitFinalizeSdkModule()
{}

TEST(ProcessExit, ProcessExitWithSpinningThread)
{
    nn::diag::EnableDefaultAbortObserver(false);

    NN_ABORT_UNLESS_RESULT_SUCCESS(
        nn::os::CreateThread(&s_SpinningThread, SpinningThreadFunc, 0, s_SpinningThreadStack, sizeof(s_SpinningThreadStack), nn::os::DefaultThreadPriority, 2));

    nn::os::StartThread(&s_SpinningThread);

    nn::os::ThreadType waiterThread;
    static NN_OS_ALIGNAS_THREAD_STACK uint8_t s_WaiterThreadStack[4096];
    // Warning: this thread must be on the same core, otherwise it might be stopped during NN_ABORT() processing in case of failure
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        nn::os::CreateThread(&waiterThread, WaiterThreadFunc, 0, s_WaiterThreadStack, sizeof(s_WaiterThreadStack), nn::os::HighestThreadPriority, nn::os::GetCurrentCoreNumber()));

    nn::os::StartThread(&waiterThread);

    quick_exit(0);
}
