﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../Common/test_Pragma.h"

#include <nn/os/os_Config.h>
#include <nn/nn_SdkText.h>
#include <nn/nn_Common.h>
#include <nn/os.h>

#include <nnt/nntest.h>


namespace nnt { namespace os {

NN_ALIGNAS(4096) nn::Bit8 g_DyingMessage[4096];

const int TestThreadMax = 95;
NN_ALIGNAS(4096) nn::Bit8 g_Stack[TestThreadMax][4096];
nn::os::ThreadType        g_Thread[TestThreadMax];

void TestFunc(void*)
{
    while (1)
    {
        nn::os::SleepThread(nn::TimeSpan::FromSeconds(1));
    }
}

TEST(DyingMessage, CallTest)
{
    for (size_t i = 0; i < sizeof(g_DyingMessage); i++)
    {
        g_DyingMessage[i] = i % 256;
    }
    nn::os::SetDyingMessageRegion(reinterpret_cast<uintptr_t>(g_DyingMessage), 256);

    for (int i = 0; i < TestThreadMax; ++i)
    {
        nn::os::CreateThread( &g_Thread[i], TestFunc, nullptr, g_Stack[i], sizeof(g_Stack[i]), nn::os::DefaultThreadPriority );
        nn::os::StartThread( &g_Thread[i] );
    }

    switch (g_DyingMessage[0])
    {
        case 1:
            break;
        default:
            break;
            //NN_UNEXPECTED_DEFAULT;
    }

    //NN_ABORT_UNLESS_RESULT_SUCCESS(nn::os::ResultOutOfMemory());
    auto ptr = reinterpret_cast<volatile int*>(0x4);
    *ptr = 0xcafe;
}

//---------------------------------------------------------------------------

}} // namespace nnt::os

