﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../Common/test_Pragma.h"

#include <nn/os/os_Config.h>
#include <nn/nn_Common.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Result.h>
#include <nn/nn_Log.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os.h>

#include <nnt/nntest.h>


namespace nnt { namespace os {

//-----------------------------------------------------------------------------

template<size_t SIZE = 0x4000>
class StackImpl
{
private:
    NN_OS_ALIGNAS_THREAD_STACK nn::Bit8 m_Stack[SIZE];

public:
    void* GetAddress() NN_NOEXCEPT
    {
        return reinterpret_cast<void*>(m_Stack);
    }

    size_t GetSize() const NN_NOEXCEPT
    {
        return SIZE;
    }

    nn::Bit8& operator[](int index)
    {
        NN_ASSERT(index >= 0 && index < SIZE);
        return m_Stack[index];
    }
};
typedef StackImpl<> Stack;


class Thread
{
private:
    nn::os::ThreadType m_Thread;

public:
    Thread(nn::os::ThreadFunction function, void* argument, Stack& stack, int pri_diff)
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS( nn::os::CreateThread(&m_Thread, function, argument, stack.GetAddress(), stack.GetSize(), nn::os::GetThreadCurrentPriority(nn::os::GetCurrentThread()) + pri_diff) );
    }

    Thread(nn::os::ThreadFunction function, void* argument, Stack& stack, int pri_diff, int core)
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS( nn::os::CreateThread(&m_Thread, function, argument, stack.GetAddress(), stack.GetSize(), nn::os::GetThreadCurrentPriority(nn::os::GetCurrentThread()) + pri_diff, core) );
    }

    ~Thread()
    {
        nn::os::DestroyThread( &m_Thread );
    }

    void Start()
    {
        nn::os::StartThread( &m_Thread );
    }

    void Wait()
    {
        nn::os::WaitThread( &m_Thread );
    }
};

//-----------------------------------------------------------------------------

}}  // namespace nnt::os

