﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
//  MemoryAccess 検査機能
//---------------------------------------------------------------------------

#include "../Common/test_Pragma.h"

#include <nn/os/os_Config.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

#include <nn/svc/svc_Base.h>
#include <nn/svc/svc_Thread.h>

#include "../Common/test_MemoryAccess.h"

namespace nnt { namespace os {
namespace detail {

//---------------------------------------------------------------------------

int32_t g_IdealCore;

//---------------------------------------------------------------------------
//  指定された address のページ属性が MemTest 通りかどうかを判定する。
//  MemTest に合致した場合は true を、そうでなければ false を返す。
bool MemoryAccessTest(uintptr_t address, MemAttribute attr)
NN_NOEXCEPT
{
    nn::svc::MemoryInfo memInfo;
    nn::svc::PageInfo   pageInfo;

    nn::svc::QueryMemory( &memInfo, &pageInfo, address );

    switch (attr)
    {
    case MemAttr_NonAccess:
            if ((memInfo.permission == nn::svc::MemoryPermission_None) &&
                (memInfo.state      == nn::svc::MemoryState_Free))
            {
                return true;
            }
            break;

    case MemAttr_Normal_None:
            if ((memInfo.permission == nn::svc::MemoryPermission_None) &&
                ((memInfo.state     == nn::svc::MemoryState_Normal) ||
                 (memInfo.state     == nn::svc::MemoryState_CodeData)))
            {
                return true;
            }
            break;

    case MemAttr_Normal_ReadOnly:
            if ((memInfo.permission == nn::svc::MemoryPermission_Read) &&
                ((memInfo.state     == nn::svc::MemoryState_Normal) ||
                 (memInfo.state     == nn::svc::MemoryState_CodeData)))
            {
                return true;
            }
            break;

    case MemAttr_Normal_ReadWrite:
            if ((memInfo.permission == nn::svc::MemoryPermission_ReadWrite) &&
                ((memInfo.state     == nn::svc::MemoryState_Normal) ||
                 (memInfo.state     == nn::svc::MemoryState_CodeData)))
            {
                return true;
            }
            break;

    case MemAttr_Normal_NonAccess_Locked:
            if ((memInfo.permission == nn::svc::MemoryPermission_None) &&
                ((memInfo.state     == nn::svc::MemoryState_Normal) ||
                 (memInfo.state     == nn::svc::MemoryState_CodeData)) &&
                (memInfo.attribute  == nn::svc::MemoryAttribute_Locked))
            {
                return true;
            }
            break;

    case MemAttr_Alias_ReadWrite:
            if ((memInfo.permission == nn::svc::MemoryPermission_ReadWrite) &&
                (memInfo.state      == nn::svc::MemoryState_Alias) &&
                (memInfo.attribute  == 0))
            {
                return true;
            }
            break;

    case MemAttr_Stack_ReadWrite:
            if ((memInfo.permission == nn::svc::MemoryPermission_ReadWrite) &&
                (memInfo.state      == nn::svc::MemoryState_Stack) &&
                (memInfo.attribute  == 0))
            {
                return true;
            }
            break;

    default:
            break;
    }

    return false;
}

//---------------------------------------------------------------------------

}   // namespace detail
}}  // namespace nnt::os

