﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../Common/test_Pragma.h"

#include <cstring>
#include <nn/os/os_Config.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os.h>
#include <nnt/nnt_Argument.h>
#include "EscapeSequence.h"

#include "../Common/test_Helper.h"
#include "../Common/test_NamedPipe.h"
#include "../Common/test_Calibration.h"

#include <nnt/nntest.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/teamcity/testTeamcity_Logger.h>


#define NNT_OS_GTEST_RUN_DEATH_TEST "--gtest_internal_run_death_test="
bool DetectMyProcessIsChildForDeathTest(int argc, char* argv[])
NN_NOEXCEPT
{
    for (int i=0; i<argc; ++i)
    {
        if (std::strncmp(argv[i], NNT_OS_GTEST_RUN_DEATH_TEST,
                           sizeof(NNT_OS_GTEST_RUN_DEATH_TEST)) == 0)
        {
            return true;
        }
    }
    return false;
}

extern "C" void nnMain()
{
    // コマンドライン引数を取得
    int    argc = nnt::GetHostArgc();
    char** argv = nnt::GetHostArgv();

    NNT_OS_LOG("TEST: argc=%d\n", argc);
    NNT_OS_LOG("TEST: argv=0x%p\n", argv);
    for (int i=0; i<argc; ++i)
    {
        NNT_OS_LOG("TEST: argv[%d]=\x22%s\x22\n", i, argv[i]);
    }

    // DeathTeath の子プロセスとして起動したかどうかのチェック
    bool childProcess = DetectMyProcessIsChildForDeathTest(argc, argv);
    if (childProcess)
    {
        // 子プロセスだった場合の処理

        // シーケンスチェッカ等の初期化
        NNT_CALIBRATE_INITIALIZE();
        SEQ_INITIALIZE();
        INITIALIZE_TEST_COUNT();

        // GoogleTest おまじない
        ::testing::InitGoogleTest(&argc, argv);
        int result = RUN_ALL_TESTS();

        // 子プロセスの終了コードを設定
        nnt::Exit( result );
    }

    // GoogleTest の通常起動

    // シーケンスチェッカ等の初期化
    NNT_CALIBRATE_INITIALIZE();
    SEQ_INITIALIZE();
    INITIALIZE_TEST_COUNT();

    // テスト開始
    SEQ_CHECK(0);
    NNT_OS_LOG("=== Start All Os Test APIs\n");

    // GoogleTest おまじない
    ::testing::InitGoogleTest(&argc, argv);

    // TeamCity の表示を適切にするため、イベントリスナの登録を一旦すべて解除し、
    // ServiceMessageLogger -> デフォルトのイベントリスナ の順で登録し直す。
    ::testing::TestEventListeners& listeners = ::testing::UnitTest::GetInstance()->listeners();
    ::testing::TestEventListener* defaultResultPrinter = listeners.Release(listeners.default_result_printer());
    listeners.Append(new nnt::teamcity::ServiceMessageLogger());
    listeners.Append(defaultResultPrinter);

    int result = RUN_ALL_TESTS();

    // テスト終了
    NNT_OS_LOG("\n=== End All Os Test APIs\n");

    // 集計結果の表示
    g_Result.Show();

    // 終了コードを設定
    nnt::Exit( result );
}
