﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//#include "../Common/test_Pragma.h"
//#include "../Common/test_Helper.h"

#include <string>
#include <nn/os/os_Config.h>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkText.h>
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/oe.h>

#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include <nnt/base/testBase_Exit.h>

namespace nnt { namespace omm { namespace oe {

//-----------------------------------------------------------------------------
//  動作モードが意図通りになっているかのテスト
//-----------------------------------------------------------------------------

namespace {

}   // namespace

TEST(Initialize, test_Initialize)
{
    nn::oe::Initialize();
}

TEST(OperationMode, test_OperationMode)
{
    auto argc = nnt::GetHostArgc();
    auto argv = nnt::GetHostArgv();

    auto checkOperationMode = nn::oe::OperationMode::OperationMode_Console;
    if (argc > 1 && std::string(argv[1]) == "handheld")
    {
        checkOperationMode = nn::oe::OperationMode_Handheld;
    }

    auto currentOperationMode = nn::oe::GetOperationMode();
    EXPECT_TRUE( currentOperationMode == checkOperationMode );
}

//-----------------------------------------------------------------------------

}}} // namespace nnt::omm::oe
