﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include <nnt/result/testResult_Assert.h>

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/util/util_FormatString.h>
#include <nn/util/util_StringUtil.h>

#include <nn/http/json/http_RapidJsonApi.h>
#include <nn/http/json/http_JsonErrorMap.h>
#include <nn/olsc/olsc_Result.h>
#include <nn/olsc/srv/olsc_InternalTypes.h>

#include <olsc_PolicyInfoAdaptor.h>
#include <olsc_OutputStream.h>

#include "testOlsc_InputStream.h"
#include "testOlsc_SaveDataUtil.h"

using namespace nn;
using namespace nn::olsc;

namespace policy_success {

const char PolicyInfoSimpleString[] =
"{"
    "\"policy_type\" : \"ALL_OK\""
"}";

struct Cancelable
{
    bool IsCancelled() const { return false; }
};

TEST(OlscJsonAdaptorTest, PolicyInfoSuccess)
{
    auto uid = nnt::olsc::GetFirstUserId();
    nn::fs::DeleteSystemSaveData(nnt::olsc::SystemSaveDataIdForTest, uid);

    olsc::srv::adaptor::PolicyInfoAdaptor adaptor;

    nnt::olsc::MemoryInputStreamForRapidJson inputStream;
    inputStream.Set(PolicyInfoSimpleString, sizeof(PolicyInfoSimpleString));

    const Cancelable c;
    NNT_EXPECT_RESULT_SUCCESS(http::json::ImportJsonByRapidJson<http::json::DefaultJsonErrorMap>(adaptor, inputStream, &c));
    NNT_EXPECT_RESULT_SUCCESS(adaptor.GetResult());

    olsc::srv::PolicyInfo policy;

    NNT_EXPECT_RESULT_SUCCESS(adaptor.GetPolicyInfo(&policy));

    EXPECT_TRUE(policy.type == olsc::srv::PolicyType::AllOk);
}

} // namespace policy_success

namespace policy_fail {
    const int JsonLen = 2048;

    const char InvalidPolicyInfo[][JsonLen] =
    {
        "{"
            "\"policy_type\" : \"ALL_K\""
        "}"
    };

    const char InvalidField[][JsonLen] =
    {
        "{"
            "\"apolicy_type\" : \"ALL_OK\""
        "}",
        "{"
        "}"
    };

struct Cancelable
{
    bool IsCancelled() const { return false; }
};

template<typename ExpectResultType>
void TestImpl(const char json[])
{
    auto uid = nnt::olsc::GetFirstUserId();
    nn::fs::DeleteSystemSaveData(nnt::olsc::SystemSaveDataIdForTest, uid);


    olsc::srv::adaptor::PolicyInfoAdaptor adaptor;

    nnt::olsc::MemoryInputStreamForRapidJson inputStream;
    inputStream.Set(json, JsonLen);

    const Cancelable c;
    NNT_EXPECT_RESULT_SUCCESS(http::json::ImportJsonByRapidJson<http::json::DefaultJsonErrorMap>(adaptor, inputStream, &c));
    NNT_EXPECT_RESULT_FAILURE(ExpectResultType, adaptor.GetResult());
}

template<typename ExpectResultType>
void RunTest(const char json[][JsonLen], int count)
{
    for (int i = 0; i < count; ++i)
    {
        TestImpl<ExpectResultType>(json[i]);
    }
}

TEST(OlscJsonAdaptorTest, KeySeedPackageFail)
{
    RunTest<olsc::ResultPolicyInfoUnacceptableContent>(InvalidPolicyInfo, sizeof(InvalidPolicyInfo) / JsonLen);
    RunTest<olsc::ResultPolicyInfoUnacceptableContent>(InvalidField, sizeof(InvalidField) / JsonLen);
}
}// policy_fail
