﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nvn/nvn_Cpp.h>

#include "AppBase.h"

class AppClass : public AppBase
{
public:
    AppClass(int width, int height, const char* title);
    ~AppClass();

    virtual void OnInit(PFNNVNBOOTSTRAPLOADERPROC loader, NVNnativeWindow nativeWindow) override;
    virtual void OnUpdate() override;
    virtual void OnRender() override;
    virtual void OnDestroy() override;

    void RequestGpuHang()
    {
        m_GpuHangRequested = true;
    }

private:
    static const int FrameCount = 2;
    static const size_t RenderTargetMemorySize = 32 * 1024 * 1024;
    static const size_t CommandMemorySize = 1024;
    static const size_t ControlMemorySize = 1024;

    struct MemoryInfo
    {
        void* memory;
        size_t size;
    };

    bool m_GpuHangRequested;

    NVNnativeWindow m_NativeWindow;
    nvn::Sync m_TextureAvailableSync;
    nvn::Device m_Device;
    nvn::Queue m_Queue;
    nvn::MemoryPool m_RenderTargetMemoryPool;
    nvn::Texture m_RenderTargets[FrameCount];
    nvn::Window m_Window;
    MemoryInfo m_CommandMemoryInfo;
    MemoryInfo m_ControlMemoryInfo;
    nvn::MemoryPool m_CommandMemoryPool;
    nvn::CommandBuffer m_CommandBuffer;
};
