﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <nn/time/time_ResultPrivate.h>
#include <nn/ntc/detail/service/core/ntc_ResponseParser.h>

TEST(ResponseParser, ParseTimeDataResponse1)
{
    int64_t out;
    const char buffer[] = "9223372036854775807\n255.255.255.255"; // max size response
    NNT_ASSERT_RESULT_SUCCESS(nn::ntc::detail::service::core::ParseTimeDataResponse(&out, buffer, sizeof(buffer)));
    EXPECT_EQ(9223372036854775807LL, out);
}

TEST(ResponseParser, ParseTimeDataResponse2)
{
    int64_t out;
    const char buffer[] = "123456\nhogehgoe";
    NNT_ASSERT_RESULT_SUCCESS(nn::ntc::detail::service::core::ParseTimeDataResponse(&out, buffer, sizeof(buffer)));
    EXPECT_EQ(123456LL, out);
}

TEST(ResponseParser, ParseTimeDataResponse3)
{
    int64_t out;
    const char buffer[] = "9223372036854775807\nhogehgoe";
    NNT_ASSERT_RESULT_SUCCESS(nn::ntc::detail::service::core::ParseTimeDataResponse(&out, buffer, sizeof(buffer)));
    EXPECT_EQ(9223372036854775807LL, out);
}

TEST(ResponseParser, ParseTimeDataResponse4)
{
    int64_t out;
    const char buffer[] = "0\nhogehoge";
    NNT_EXPECT_RESULT_FAILURE(nn::time::ResultInvalidServerResponse,
        nn::ntc::detail::service::core::ParseTimeDataResponse(&out, buffer, sizeof(buffer)));
}

TEST(ResponseParser, ParseTimeDataResponse5)
{
    int64_t out;
    const char buffer[] = "9223372036854775807hogehgoe";
    NNT_EXPECT_RESULT_FAILURE(nn::time::ResultInvalidServerResponse,
        nn::ntc::detail::service::core::ParseTimeDataResponse(&out, buffer, sizeof(buffer)));
}

TEST(ResponseParser, ParseTimeDataResponse6)
{
    int64_t out;
    const char buffer[] = "!\"#$%&'()";
    NNT_EXPECT_RESULT_FAILURE(nn::time::ResultInvalidServerResponse,
        nn::ntc::detail::service::core::ParseTimeDataResponse(&out, buffer, sizeof(buffer)));
}

TEST(ResponseParser, ParseTimeDataResponse7)
{
    int64_t out;
    const char buffer[] = "\n!\"#$%&'()";
    NNT_EXPECT_RESULT_FAILURE(nn::time::ResultInvalidServerResponse,
        nn::ntc::detail::service::core::ParseTimeDataResponse(&out, buffer, sizeof(buffer)));
}

TEST(ResponseParser, ParseTimeDataResponse8)
{
    int64_t out;
    const char buffer[] = "";
    NNT_EXPECT_RESULT_FAILURE(nn::time::ResultInvalidServerResponse,
        nn::ntc::detail::service::core::ParseTimeDataResponse(&out, buffer, sizeof(buffer)));
}

TEST(ResponseParser, ParseTimeDataResponse9)
{
    int64_t out;
    const char buffer[] = "\n";
    NNT_EXPECT_RESULT_FAILURE(nn::time::ResultInvalidServerResponse,
        nn::ntc::detail::service::core::ParseTimeDataResponse(&out, buffer, sizeof(buffer)));
}

TEST(ResponseParser, ParseTimeDataResponse10)
{
    int64_t out;
    char buffer[10] = "12345\naaa";
    buffer[9] = 'a'; // NULL 終端を壊す
    NNT_EXPECT_RESULT_FAILURE(nn::time::ResultInvalidServerResponse,
        nn::ntc::detail::service::core::ParseTimeDataResponse(&out, buffer, 10));
}
