﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <nn/nsd/nsd_ApiForMenu.h>
#include <nn/nsd/nsd_ApiForMiddleware.h> //設定削除に関連した Resolve 確認のため
#include <nn/nsd/nsd_ApiForTest.h>
#include <nn/nsd/nsd_ResultPrivate.h>
#include <nn/util/util_StringUtil.h>

#if NN_BUILD_CONFIG_OS_WIN

// Windows.h マクロと衝突しないかの確認

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif

#ifndef NOMINMAX
#define NOMINMAX
#endif

#include <nn/nn_Windows.h>

#endif // NN_BUILD_CONFIG_OS_WIN

using namespace nn::nsd;

namespace
{
    uint8_t g_WorkBuffer[1024 * 256] = {};
}

// nsd:a なしで ImportSettings を呼ぶ
TEST(NsdTest_NotPermitted, ImportSettingsWithNsdU)
{
    // Windows では nsd:a の制限ができないので除外
#ifndef NN_BUILD_CONFIG_OS_WIN
    const char SampleInput[] =
        "eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJTZXR0aW5nTmFtZSI6IlNhbXBsZSBbMjAxNi0wNy0wOCAwNDoyNjoyMyBVVENdIiwiRW52aXJvbm1lbnQiOiJkZDEiLCJCYWNrYm9uZVNldHRpbmdzIjp7Ik5hcyI6eyJSZXF1ZXN0RnFkbiI6ImU5N2I4YTlkNjcyZTRjZTQ4NDVlYzY5NDdjZDY2ZWY2LXNiLmFjY291bnRzLm5pbnRlbmRvLmNvbSIsIkFwaUZxZG4iOiJlOTdiOGE5ZDY3MmU0Y2U0ODQ1ZWM2OTQ3Y2Q2NmVmNi1zYi1hcGkuYWNjb3VudHMubmludGVuZG8uY29tIiwiTnhBY2NvdW50Ijp7IkNsaWVudElkIjoxMjg1NTIzMDAzNDgzMjM1OTc1OSwiUmVkaXJlY3RVcmkiOiJuaW50ZW5kbzovL2FjY291bnQubnguc3lzIn0sIk54U2hvcCI6eyJDbGllbnRJZCI6MTUxNjAyMDg0MDgzMDQ3NzMyMjcsIlJlZGlyZWN0VXJpIjoibmludGVuZG86Ly9zaG9wLm54LnN5cyJ9fSwiRnFkbkVudHJpZXMiOltbInh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4LXNiLmFjY291bnRzLm5pbnRlbmRvLmNvbSIsImU5N2I4YTlkNjcyZTRjZTQ4NDVlYzY5NDdjZDY2ZWY2LXNiLmJhYXMubmludGVuZG8uY29tIl1dfSwiQXBwbGljYXRpb25TZXR0aW5ncyI6eyJGcWRuRW50cmllcyI6W1sic291cmNlMS5leGFtcGxlLmNvbSIsImRlc3RpbmF0aW9uMS5leGFtcGxlLmNvbSJdLFsic291cmNlMi5leGFtcGxlLmNvbSIsImRlc3RpbmF0aW9uMi5leGFtcGxlLmNvbSJdXX0sIkV4cGlyZSI6MTU0ODYzMzYwMCwiVmVyc2lvbiI6MSwiRGV2aWNlSWQiOiIwMTIzNDU2Nzg5In0.TlNHosxEuMmq_eEIs9spYbcUc3m5be0OcVrvDv_1frkYpVq6yuHi6SUH5Vpq0a4EqF5bLt0bO3XhIC0kxuAtuSaR2E3mn-R1RBEICr7Lh0OK_x9QB3Rrhk4TyYui-iXczXCKlEuD5rMPjcZhyEIJp76xclVHQ9z4e9p8mIUGmhj1p9orGw1tZKYckIe5ygAZnZp57nkagtzj9qSmq66sLERWgLfJILdgPzcVzRZjAgbAjx0pbxPGVeHZgAjU-zVpB_YknZAXwj-haZPkFlijufWI8i-gsD_hcG1NbZndhD4bZVqwwdlP50_zWoy6it73h_Fcz4Nm4mUbgZlDCk_c6Q";


    NNT_EXPECT_RESULT_FAILURE( nn::nsd::ResultNotPermitted,
                               nn::nsd::ImportSettings(
                               static_cast<const void*>(SampleInput), sizeof(SampleInput),
                               g_WorkBuffer, sizeof(g_WorkBuffer),
                               nn::nsd::ImportMode_All) );

    NNT_EXPECT_RESULT_FAILURE( nn::nsd::ResultNotPermitted,
                               nn::nsd::ImportSettings(
                               static_cast<const void*>(SampleInput), sizeof(SampleInput),
                               g_WorkBuffer, sizeof(g_WorkBuffer),
                               nn::nsd::ImportMode_ApplicationSettings) );
#endif
}

// nsd:a なしで DeleteSettings を呼ぶ
TEST(NsdTest_NotPermitted, DeleteSettingsNsdU)
{
    // Windows では nsd:a の制限ができないので除外
#ifndef NN_BUILD_CONFIG_OS_WIN

    NNT_EXPECT_RESULT_FAILURE( nn::nsd::ResultNotPermitted,
                               nn::nsd::DeleteSettingsEx(nn::nsd::DeleteMode_All) );

    NNT_EXPECT_RESULT_FAILURE( nn::nsd::ResultNotPermitted,
                               nn::nsd::DeleteSettingsEx(nn::nsd::DeleteMode_ApplicationSettings) );
#endif
}
