﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/nsd/nsd_Types.h>
#include <nn/nsd/nsd_BackboneSettingsTypes.h>

namespace nnt { namespace nsd { namespace constant {

    // unknown 系定数
    static const nn::nsd::Fqdn InvalidFqdn = {"unknown.dummy.nintendo.net"};
    static const nn::nsd::NasServiceSetting InvalidNasServiceSetting =
    {
        0,
        {"nintendo://unknown.nx.sys"}
    };

    struct EnvironmentSetting
    {
        nn::nsd::Fqdn nasApiFqdn;
        nn::nsd::Fqdn nasRequestFqdn;
        nn::nsd::Fqdn baasFqdn;
        nn::nsd::NasServiceSetting nasServiceSettingOfNxAccount;
        nn::nsd::NasServiceSetting nasServiceSettingOfNxShop;
        nn::nsd::NasServiceSetting nasServiceSettingOfNxFriends;
        nn::nsd::NasServiceSetting nasServiceSettingOfNxELicense;
    };

    // dd1 定数
    static const EnvironmentSetting Dd1 =
    {
        {"e97b8a9d672e4ce4845ec6947cd66ef6-sb-api.accounts.nintendo.com"},
        {"e97b8a9d672e4ce4845ec6947cd66ef6-sb.accounts.nintendo.com"},
        {"e97b8a9d672e4ce4845ec6947cd66ef6-sb.baas.nintendo.com"},
        {
            12855230034832359759ULL, //0xb266f39b541d814fULL
            {"nintendo://account.nx.sys"}
        },
        {
            15160208408304773227ULL, //0xd263e139a1e5686bULL
            {"nintendo://shop.nx.sys"}
        },
        {
            17427995557043336505ULL, //0xf1dcad9f24a77539LL
            {"nintendo://friends.nx.sys"}
        },
        {
            4435007447274996940ULL, //0x3d8c4fc68f09c4ccULL,
            {"nintendo://e-license.nx.sys"}
        }
    };

    // td1 定数
    static const EnvironmentSetting Td1 =
    {
        {"e03a97819c9711e59510d820a52f298a-sb-api.accounts.nintendo.com"},
        {"e03a97819c9711e59510d820a52f298a-sb.accounts.nintendo.com"},
        {"e03a97819c9711e59510d820a52f298a-sb.baas.nintendo.com"},
        {
            14598592992090328170ULL, // 0xca989efaca0d0c6aULL
            {"nintendo://account.nx.sys"}
        },
        {
            13123894789993355463ULL, // 0xb62170c7332758c7ULL
            {"nintendo://shop.nx.sys"}
        },
        {
            6518476238910173761ULL, // 0x5a76479a5910b241ULL
            {"nintendo://friends.nx.sys"}
        },
        {
            5019508564877057394ULL, // 0x45a8e071fc871d72ULL
            {"nintendo://e-license.nx.sys"}
        },
    };

    // lp1 定数
    static const EnvironmentSetting Lp1 =
    {
        {"api.accounts.nintendo.com"},
        {"accounts.nintendo.com"},
        {"e0d67c509fb203858ebcb2fe3f88c2aa.baas.nintendo.com"},
        {
            8069730095319942088ULL, // 0x6ffd70c434d303c8ULL
            {"nintendo://account.nx.sys"}
        },
        {
            16528775661516061200ULL, // 0xe56201e414c97a10
            {"nintendo://shop.nx.sys"}
        },
        {
            6328643424891897513ULL, // 0x57d3dbaa12cb06a9ULL
            {"nintendo://friends.nx.sys"}
        },
        {
            5248613245010475735ULL, // 0x48d6d1f020427ad7ULL,
            {"nintendo://e-license.nx.sys"}
        }
    };
}}}
