<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Generate meta file of add-on content

    .DESCRIPTION
        Generate meta file of add-on content
#>
[CmdletBinding()]
Param
(
    [Parameter(Mandatory=$True)]
    [string]
    $OutputDirectoryPath,

    [Parameter(Mandatory=$True)]
    [string]
    $OutputFileName,

    [string]
    $StartAppId = "0x0005000c10000000",

    [Int]
    $StartVersion = 0,

    [Int]
    $StartRequiredVersion = 0,

    [Int]
    $EntryCount = 10,

    [Int]
    $LastModified = 0,

    [Int]
    $FormatVersion = 1,

    [Switch]
    $SkipOutputRequiredVersion
)

trap [Exception]
{
    Write-Host $_
    exit 1
}

$titles = @()
$versionList = @{format_version = $FormatVersion;last_modified = $LastModified}
for($i = 0; $i -lt $EntryCount; $i++)
{
    $appId = [Convert]::ToInt64($StartAppId, 16) + $i
    $version = ($StartVersion + $i) -shl 16
    $requiredVersion = ($StartRequiredVersion + $i) -shl 16

    $title = @{id = [String]::Format("0x{0:x16}", $appId); version = $version}
    if ( -Not $SkipOutputRequiredVersion )
    {
        $title.Add("required_version", $requiredVersion)
    }
    $titles += $title
}

$versionList.Add("titles", $titles)

$newDir = New-Item $OutputDirectoryPath -Force -Type directory
$output = Join-Path $OutputDirectoryPath $OutputFileName
$versionList | ConvertTo-Json | Set-Content $output -Encoding UTF8
