﻿<#
    $ powershell -Version 2.0 -ExecutionPolicy Unrestricted SdevPowerOffByFileDetection.ps1
    使用していないです。
    Runspace サンプルに残す。
    ../ にコピーして使用します。
#>

# main 引数
param (
    # Qualify the platforms
    [string] $Platform = "NX-NXFP2-a64",

    # Qualify the build types
    [string] $BuildType = "Develop",

    # Qualify the name of test module.
    [string] $TestModuleName = "testNs_NupAbortOnInstall",

    # Qualify the advisory file path for trigger of power-off.
    [string] $AdvisoryFileName = "InstallRun.advisory.txt",

    # Qualify the intermediate working folder path.
    [string] $IntermediateDirectory = "F:\home\workbench\siglo\sdk1\Tests\Outputs\AnyCPU\Tests\testNs_NupAbortOnUpdate\Develop",

    # Qualify the regex pattern string of force process exit.
    [string] $ForceExitPattern = "\bRequest force process exit:"
)

# スクリプトパス関連 ( 全部文字列型らしい [string] )
$MyScriptPath          = $MyInvocation.MyCommand.Path
$MyScriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyScriptPath)
$BasicModulePath       = "${MyScriptDirectoryPath}\..\..\SystemUpdateBasic\Scripts\Modules"

Import-Module "${BasicModulePath}\PlatformUtilities"

# SDK ROOTパス
$NintendoSdkRootPath = $(Find-NintendoSdkRootPath)

# NintendoSDK Integrate script module インポート
Import-Module "${NintendoSdkRootPath}\Integrate\Scripts\Modules\Error"
Import-Module "${NintendoSdkRootPath}\Integrate\Scripts\Modules\Path"
Import-Module "${NintendoSdkRootPath}\Integrate\Scripts\Modules\HostBridge"

Import-Module "${BasicModulePath}\FileUtilities"
Import-Module "${BasicModulePath}\SdkToolUtilities"

Import-Module "${MyScriptDirectoryPath}\Modules\RunspaceUtilities"
Import-Module "${MyScriptDirectoryPath}\Modules\FileWatcher"

# ================================
# ExitCode 宣言
# ================================
[int] $defExitCode = 0

# ================================
# main
# ================================
try {
    # CIジョブでのTestRunnerは、nact経由でステップ実行し、nactはUTF8で出力を受信している。
    # そのため、強制的にコンソールをUTF-8としている。
    # 但し通常のコード932のDOS窓上では本スクリプトから、Write-Hostなどに日本語指定が使えないので注意。
    $defUseEncoding = New-Object System.Text.UTF8Encoding($False)
    $defBackupConsoleEncoding = [System.Console]::OutputEncoding
    $defBackupEncode = $OutputEncoding
    [System.Console]::OutputEncoding = ${defUseEncoding}
    $OutputEncoding = ${defUseEncoding}

    # エンコード情報表示
    [string] $defConsoleEncode = [System.Console]::OutputEncoding.EncodingName
    [string] $defStartupEncode = $defBackupEncode.EncodingName
    [string] $defCurrentEncode = $OutputEncoding.EncodingName
    Write-Host "[Console]::OutputEncoding : ${defConsoleEncode}"
    Write-Host "Startup `$OutputEncoding   : ${defStartupEncode}"
    Write-Host "Current `$OutputEncoding   : ${defCurrentEncode}"

    # プラットフォームチェック
    $Platform = Resolve-PlatformConstants( ${Platform} )

    # 中間ファイル作成作業フォルダ存在確認
    [string] $IntermediateDirectory = $(Get-AbsoluteFullPath ${IntermediateDirectory})
    $(Edit-MakeDirectory ${IntermediateDirectory})

    Write-Host "============== Script configuration. =============="
    Write-Host "Platform        : ${Platform}"
    Write-Host "BuildType       : ${BuildType}"
    Write-Host "TestModuleName  : ${TestModuleName}"
    Write-Host "SDK Root        : ${NintendoSdkRootPath}"
    Write-Host "ScriptPath      : ${MyScriptPath}"
    Write-Host "ScriptDirectory : ${MyScriptDirectoryPath}"

    # テスト用 nsp の検索
    [string] $defTestNsp = $(Search-AvailableTestModuleNsp ${NintendoSdkRootPath} ${Platform} ${BuildType} ${TestModuleName})
    # RunOnTargetPrivate.exe の検索
    [string] $exeRunOnTarget = $(Search-AvailableRunOnTargetPrivate ${NintendoSdkRootPath})
    # ControlTarget.exe の検索
    [string] $exeControlTarget = $(Search-AvailableControlTarget ${NintendoSdkRootPath})
    # ターゲットアドレス の検索
    [string] $defTargetIp = $(Get-SigleTargetAddress 169.*)

    # アドバイザリファイル環境設定
    [string] $defAdvisoryFileDirectoryName = ${IntermediateDirectory}
    [string] $defAdvisoryFileName = ${AdvisoryFileName}
    [string] $defOutFilePath = "${defAdvisoryFileDirectoryName}\${defAdvisoryFileName}"
    Remove-ExistFile( ${defOutFilePath} )

    # 準備ができたらアドバイザリファイルの生成
    "setup ok." | Set-Content "${defOutFilePath}" -Encoding UTF8 | Out-Null
    Write-Host "`n[Script] Create advisory file : ${defOutFilePath}"
    Write-Host "[Script] Advisory erasing nsp : ${defTestNsp}"

    # サブスレッド引数準備
    $defRsArguments = New-Object PSObject -Property @{
        vAdvisoryFileDirectoryName = ${defAdvisoryFileDirectoryName}
        vAdvisoryFileName = ${defAdvisoryFileName}
        vControlTarget = ${exeControlTarget}
    }

    # サブスレッドでファイル監視
    $ObserveHandle = $(Open-Runspace {
        Param (
            $RsHandle,
            $RsArguments
        )
        try {
            $defWatcher = New-Object System.IO.FileSystemWatcher
            $defWatcher.Path = $RsArguments.vAdvisoryFileDirectoryName
            $defWatcher.Filter = $RsArguments.vAdvisoryFileName
            $defWatcher.NotifyFilter = [System.IO.NotifyFilters]::FileName
            $defWatcher.WaitForChanged( [System.IO.WatcherChangeTypes]::Deleted ) | Out-Null

            # == ここから
            # Turn-off the target.
            $exeControlTarget = $RsArguments.vControlTarget
            Invoke-Expression "& `"${exeControlTarget}`" power-off"
            $defRsResult = "[Script] Detect power-off request in the installing step."
            # == ここまでが、中断用ブロック
            # RsArguments に ScriptBlock 渡して Invoke() しても良い.
        } catch [Exception] {
            $defRsResult = "[Script] Error on Runspace = [ $_ ]"
        } finally {
        }
        return ${defRsResult}
    } ${defRsArguments})

    # テストプログラム同期実施
    [string] $defNspArgCase  = "--testns_AbortCase=ScriptTest"
    [string] $defNspArgMount = "--testns_MountHost=${IntermediateDirectory}"
    [string] $defFailExit0 = "--pattern-failure-exit `"\bAssertion Failure:`""
    [string] $defFailExit1 = "--pattern-failure-exit `"\bPrecondition not met:`""
    [string] $defFailExit2 = "--pattern-failure-exit `"\bUnexpected Default:`""
    [string] $defFailExit3 = "--pattern-failure-exit `"\bAbort:`""
    [string] $defSafeExit0 = "--pattern-success-exit `"${ForceExitPattern}`""
    [string] $defRunCommand = "`"${exeRunOnTarget}`" run `"${defTestNsp}`" ${defFailExit0} ${defFailExit1} ${defFailExit2} ${defFailExit3} ${defSafeExit0} `"--verbose`" `"--monitor-serial`" `"--hostbridge`" `"${defTargetIp}`" `"--`" `"${defNspArgMount}`" `"${defNspArgCase}`""
    Invoke-Expression "& ${defRunCommand} | Write-Host"

    # ===================================================================
    # Cuation
    # ファイル検出で SDEV power-off しても、RunOnTarget が終了しない。
    # --pattern-success-exit で意図的に終わらせてみたら、power-off が RunOnTargetの終了処理中に発生するとやっぱり終わらない。
    # というか、どうせ --pattern-success-exit での RunOnTarget 終了に依存するならファイル検出いらないよね。
    # ってことで、このRunspace の仕組み不要になりました。
    # ===================================================================

    # テストプログラムが Failure ならアドバイザリを明示的に削除.
    if ( $(Test-Path ${defOutFilePath}) )
    {
        Write-Host "`n[Script] The test module `"${TestModuleName}`" was failed."
        Remove-ExistFile( ${defOutFilePath} )
        $defExitCode = 1
    }
    Write-Host "exit ${defExitCode}"
    Wait-Runspace( $ObserveHandle ) | Write-Host

    # ここから、中断後の終了処理
    # Reset interval.
    Start-Sleep -s 5

    # Turn-on the target.
    Invoke-Expression "& `"${exeControlTarget}`" power-on"
    Write-Host "[Script] Power-on the target, and wait a boot sequence complete."

    # Interval for wait a boot sequence complete.
    Start-Sleep -s 20
    Write-Host "[Script] Finish to interval for wait a boot sequence complete."
    # ここまで、中断後の終了処理

} catch [Exception] {

    Write-ErrorRecord $_
    $defExitCode = 1

} finally {

    Close-Runspace( $ObserveHandle )
    $OutputEncoding = $defBackupEncode
    [System.Console]::OutputEncoding = $defBackupConsoleEncoding

}
exit ${defExitCode}


