﻿<#
    $ powershell -Version 2.0 -ExecutionPolicy Unrestricted SdevPowerOffByFileDetection.ps1
#>

# main 引数
param (
    # Qualify the platforms
    [string] $Platform = "NX-NXFP2-a64",

    # Qualify the build types
    [string] $BuildType = "Develop",

    # Qualify the name of test module.
    [string] $TestModuleName = "testNs_NupAbortOnInstall",

    # Qualify the intermediate working folder path.
    [string] $IntermediateDirectory = "F:\home\workbench\siglo\sdk1\Tests\Outputs\AnyCPU\Tests\testNs_NupAbortOnUpdate\Develop",

    # Qualify the regex pattern string of force process exit.
    [string] $ForceExitPattern = "\bRequest force process exit:",

    [string]
    $TargetName,

    [string]
    $TargetAddress
)

# スクリプトパス関連 ( 全部文字列型らしい [string] )
$MyScriptPath          = $MyInvocation.MyCommand.Path
$MyScriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyScriptPath)
$BasicModulePath       = "${MyScriptDirectoryPath}\..\..\SystemUpdateBasic\Scripts\Modules"

Import-Module "${BasicModulePath}\PlatformUtilities"

# SDK ROOTパス
$NintendoSdkRootPath = $(Find-NintendoSdkRootPath)

# NintendoSDK Integrate script module インポート
Import-Module "${NintendoSdkRootPath}\Integrate\Scripts\Modules\Error"
Import-Module "${NintendoSdkRootPath}\Integrate\Scripts\Modules\Path"
Import-Module "${NintendoSdkRootPath}\Integrate\Scripts\Modules\HostBridge"

Import-Module "${BasicModulePath}\FileUtilities"
Import-Module "${BasicModulePath}\SdkToolUtilities"

if ([string]::IsNullOrEmpty($TargetAddress)) {
    if ([string]::IsNullOrEmpty($TargetName)) {
        throw "TargetAddress and TargetName not specified"
    } else {
        $TargetAddress = Get-TargetAddressFromSerial $TargetName
    }
}

# ================================
# ExitCode 宣言
# ================================
[int] $defExitCode = 0

# ================================
# main
# ================================
try {
    # CIジョブでのTestRunnerは、nact経由でステップ実行し、nactはUTF8で出力を受信している。
    # そのため、強制的にコンソールをUTF-8としている。
    # 但し通常のコード932のDOS窓上では本スクリプトから、Write-Hostなどに日本語指定が使えないので注意。
    $defUseEncoding = New-Object System.Text.UTF8Encoding($False)
    $defBackupConsoleEncoding = [System.Console]::OutputEncoding
    $defBackupEncode = $OutputEncoding
    [System.Console]::OutputEncoding = ${defUseEncoding}
    $OutputEncoding = ${defUseEncoding}

    # エンコード情報表示
    [string] $defConsoleEncode = [System.Console]::OutputEncoding.EncodingName
    [string] $defStartupEncode = $defBackupEncode.EncodingName
    [string] $defCurrentEncode = $OutputEncoding.EncodingName
    Write-Host "[Console]::OutputEncoding : ${defConsoleEncode}"
    Write-Host "Startup `$OutputEncoding   : ${defStartupEncode}"
    Write-Host "Current `$OutputEncoding   : ${defCurrentEncode}"

    # プラットフォームチェック
    $Platform = Resolve-PlatformConstants( ${Platform} )

    # 中間ファイル作成作業フォルダ存在確認
    [string] $IntermediateDirectory = $(Get-AbsoluteFullPath ${IntermediateDirectory})
    $(Edit-MakeDirectory ${IntermediateDirectory})

    Write-Host "============== Script configuration. =============="
    Write-Host "Platform        : ${Platform}"
    Write-Host "BuildType       : ${BuildType}"
    Write-Host "TestModuleName  : ${TestModuleName}"
    Write-Host "SDK Root        : ${NintendoSdkRootPath}"
    Write-Host "ScriptPath      : ${MyScriptPath}"
    Write-Host "ScriptDirectory : ${MyScriptDirectoryPath}"

    # テスト用 nsp の検索
    [string] $defTestNsp = $(Search-AvailableTestModuleNsp ${NintendoSdkRootPath} ${Platform} ${BuildType} ${TestModuleName})
    # RunOnTargetPrivate.exe の検索
    [string] $exeRunOnTarget = $(Search-AvailableRunOnTargetPrivate ${NintendoSdkRootPath})
    # ControlTarget.exe の検索
    [string] $exeControlTarget = $(Search-AvailableControlTarget ${NintendoSdkRootPath})

    # テストプログラム同期実施
    # テストプログラム側で --pattern-success-exit に指定したキーワードをログ出力したら、RunOnTargetが終了する.
    [string] $defNspArgCase  = "--testns_AbortCase=Install"
    [string] $defNspArgMount = "--testns_MountHost=${IntermediateDirectory}"
    [string] $defFailExit0 = "--pattern-failure-exit `"\bAssertion Failure:`""
    [string] $defFailExit1 = "--pattern-failure-exit `"\bPrecondition not met:`""
    [string] $defFailExit2 = "--pattern-failure-exit `"\bUnexpected Default:`""
    [string] $defFailExit3 = "--pattern-failure-exit `"\bAbort:`""
    [string] $defSafeExit0 = "--pattern-success-exit `"${ForceExitPattern}`""
    [string] $defRunCommand = "`"${exeRunOnTarget}`" run `"--target`" `"${TargetAddress}`" `"${defTestNsp}`" ${defFailExit0} ${defFailExit1} ${defFailExit2} ${defFailExit3} ${defSafeExit0} `"--verbose`" `"--monitor-serial`" `"--hostbridge`" `"${TargetAddress}`" `"--`" `"${defNspArgMount}`" `"${defNspArgCase}`""
    Invoke-Expression "& ${defRunCommand} | Write-Host"

    if ( 0 -ne ${LastExitCode} )
    {
        $defExitCode = 1
    }

    # -----
    # ここから、中断後の終了処理
    # -----
    Invoke-Expression "& `"${exeControlTarget}`" connect --reset --target $TargetAddress"
    Write-Host "[Script] Detect reset request in the installing step."

    # Interval for wait a boot sequence complete.
    Start-Sleep -s 20
    Write-Host "[Script] Finish to interval for wait a boot sequence complete."

    # -----
    # ここまで、中断後の終了処理
    # -----
} catch [Exception] {

    Write-ErrorRecord $_
    $defExitCode = 1

} finally {

    $OutputEncoding = $defBackupEncode
    [System.Console]::OutputEncoding = $defBackupConsoleEncoding

}
exit ${defExitCode}


